/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure;

import io.nem.sdk.infrastructure.TransactionMapping;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.Deadline;
import io.nem.sdk.model.transaction.ModifyMultisigAccountTransaction;
import io.nem.sdk.model.transaction.MultisigCosignatoryModification;
import io.nem.sdk.model.transaction.MultisigCosignatoryModificationType;
import io.nem.sdk.model.transaction.TransactionInfo;
import io.vertx.core.json.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class MultisigModificationTransactionMapping
extends TransactionMapping {
    MultisigModificationTransactionMapping() {
    }

    @Override
    public ModifyMultisigAccountTransaction apply(JsonObject input) {
        TransactionInfo transactionInfo = this.createTransactionInfo(input.getJsonObject("meta"));
        JsonObject transaction = input.getJsonObject("transaction");
        Deadline deadline = new Deadline(this.extractBigInteger(transaction.getJsonArray("deadline")));
        NetworkType networkType = this.extractNetworkType(transaction.getInteger("version"));
        List<MultisigCosignatoryModification> modifications = transaction.containsKey("modifications") ? transaction.getJsonArray("modifications").stream().map(item -> (JsonObject)item).map(multisigModification -> new MultisigCosignatoryModification(MultisigCosignatoryModificationType.rawValueOf(multisigModification.getInteger("type")), PublicAccount.createFromPublicKey(multisigModification.getString("cosignatoryPublicKey"), networkType))).collect(Collectors.toList()) : Collections.emptyList();
        return new ModifyMultisigAccountTransaction(networkType, this.extractTransactionVersion(transaction.getInteger("version")), deadline, this.extractBigInteger(transaction.getJsonArray("fee")), (int)transaction.getInteger("minApprovalDelta"), (int)transaction.getInteger("minRemovalDelta"), modifications, transaction.getString("signature"), new PublicAccount(transaction.getString("signer"), networkType), transactionInfo);
    }
}

