/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure;

import io.nem.sdk.infrastructure.TransactionMapping;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.mosaic.MosaicId;
import io.nem.sdk.model.mosaic.MosaicSupplyType;
import io.nem.sdk.model.transaction.Deadline;
import io.nem.sdk.model.transaction.MosaicSupplyChangeTransaction;
import io.nem.sdk.model.transaction.TransactionInfo;
import io.vertx.core.json.JsonObject;

class MosaicSupplyChangeTransactionMapping
extends TransactionMapping {
    MosaicSupplyChangeTransactionMapping() {
    }

    @Override
    public MosaicSupplyChangeTransaction apply(JsonObject input) {
        TransactionInfo transactionInfo = this.createTransactionInfo(input.getJsonObject("meta"));
        JsonObject transaction = input.getJsonObject("transaction");
        Deadline deadline = new Deadline(this.extractBigInteger(transaction.getJsonArray("deadline")));
        return new MosaicSupplyChangeTransaction(this.extractNetworkType(transaction.getInteger("version")), this.extractTransactionVersion(transaction.getInteger("version")), deadline, this.extractBigInteger(transaction.getJsonArray("fee")), new MosaicId(this.extractBigInteger(transaction.getJsonArray("mosaicId"))), MosaicSupplyType.rawValueOf(transaction.getInteger("direction")), this.extractBigInteger(transaction.getJsonArray("delta")), transaction.getString("signature"), new PublicAccount(transaction.getString("signer"), this.extractNetworkType(transaction.getInteger("version"))), transactionInfo);
    }
}

