/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure;

import com.fasterxml.jackson.core.type.TypeReference;
import io.nem.sdk.infrastructure.Http;
import io.nem.sdk.infrastructure.MosaicInfoDTO;
import io.nem.sdk.infrastructure.MosaicNameDTO;
import io.nem.sdk.infrastructure.MosaicPropertiesDTO;
import io.nem.sdk.infrastructure.MosaicRepository;
import io.nem.sdk.infrastructure.NetworkHttp;
import io.nem.sdk.infrastructure.QueryParams;
import io.nem.sdk.infrastructure.UInt64DTO;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.MosaicId;
import io.nem.sdk.model.mosaic.MosaicInfo;
import io.nem.sdk.model.mosaic.MosaicName;
import io.nem.sdk.model.mosaic.MosaicProperties;
import io.nem.sdk.model.namespace.NamespaceId;
import io.nem.sdk.model.transaction.UInt64;
import io.reactivex.Observable;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.ext.web.codec.BodyCodec;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class MosaicHttp
extends Http
implements MosaicRepository {
    public MosaicHttp(String host) throws MalformedURLException {
        this(host, new NetworkHttp(host));
    }

    public MosaicHttp(String host, NetworkHttp networkHttp) throws MalformedURLException {
        super(host, networkHttp);
    }

    @Override
    public Observable<MosaicInfo> getMosaic(MosaicId mosaicId) {
        Observable<NetworkType> networkTypeResolve = this.getNetworkTypeObservable();
        return networkTypeResolve.flatMap(networkType -> this.client.getAbs(this.url + "/mosaic/" + UInt64.bigIntegerToHex(mosaicId.getId())).as(BodyCodec.jsonObject()).rxSend().toObservable().map(Http::mapJsonObjectOrError).map(json -> (MosaicInfoDTO)this.objectMapper.readValue(json.toString(), MosaicInfoDTO.class)).map(mosaicInfoDTO -> new MosaicInfo(mosaicInfoDTO.getMeta().isActive(), mosaicInfoDTO.getMeta().getIndex(), mosaicInfoDTO.getMeta().getId(), new NamespaceId(mosaicInfoDTO.getMosaic().getNamespaceId().extractIntArray()), new MosaicId(mosaicInfoDTO.getMosaic().getMosaicId().extractIntArray()), mosaicInfoDTO.getMosaic().getSupply().extractIntArray(), mosaicInfoDTO.getMosaic().getHeight().extractIntArray(), new PublicAccount(mosaicInfoDTO.getMosaic().getOwner(), (NetworkType)((Object)networkType)), this.extractMosaicProperties(mosaicInfoDTO.getMosaic().getProperties()))));
    }

    @Override
    public Observable<List<MosaicInfo>> getMosaics(List<MosaicId> mosaicIds) {
        JsonObject requestBody = new JsonObject();
        requestBody.put("mosaicIds", mosaicIds.stream().map(id -> UInt64.bigIntegerToHex(id.getId())).collect(Collectors.toList()));
        Observable<NetworkType> networkTypeResolve = this.getNetworkTypeObservable();
        return networkTypeResolve.flatMap(networkType -> this.client.postAbs(this.url + "/mosaic").as(BodyCodec.jsonArray()).rxSendJson((Object)requestBody).toObservable().map(Http::mapJsonArrayOrError).map(json -> (List)this.objectMapper.readValue(json.toString(), (TypeReference)new TypeReference<List<MosaicInfoDTO>>(){})).flatMapIterable(item -> item).map(mosaicInfoDTO -> new MosaicInfo(mosaicInfoDTO.getMeta().isActive(), mosaicInfoDTO.getMeta().getIndex(), mosaicInfoDTO.getMeta().getId(), new NamespaceId(mosaicInfoDTO.getMosaic().getNamespaceId().extractIntArray()), new MosaicId(mosaicInfoDTO.getMosaic().getMosaicId().extractIntArray()), mosaicInfoDTO.getMosaic().getSupply().extractIntArray(), mosaicInfoDTO.getMosaic().getHeight().extractIntArray(), new PublicAccount(mosaicInfoDTO.getMosaic().getOwner(), (NetworkType)((Object)networkType)), this.extractMosaicProperties(mosaicInfoDTO.getMosaic().getProperties()))).toList().toObservable());
    }

    @Override
    public Observable<List<MosaicInfo>> getMosaicsFromNamespace(NamespaceId namespaceId, QueryParams queryParams) {
        return this.getMosaicsFromNamespace(namespaceId, Optional.of(queryParams));
    }

    @Override
    public Observable<List<MosaicInfo>> getMosaicsFromNamespace(NamespaceId namespaceId) {
        return this.getMosaicsFromNamespace(namespaceId, Optional.empty());
    }

    private Observable<List<MosaicInfo>> getMosaicsFromNamespace(NamespaceId namespaceId, Optional<QueryParams> queryParams) {
        Observable<NetworkType> networkTypeResolve = this.getNetworkTypeObservable();
        return networkTypeResolve.flatMap(networkType -> this.client.getAbs(this.url + "/namespace/" + UInt64.bigIntegerToHex(namespaceId.getId()) + "/mosaics" + (queryParams.isPresent() ? ((QueryParams)queryParams.get()).toUrl() : "")).as(BodyCodec.jsonArray()).rxSend().toObservable().map(Http::mapJsonArrayOrError).map(json -> (List)this.objectMapper.readValue(json.toString(), (TypeReference)new TypeReference<List<MosaicInfoDTO>>(){})).flatMapIterable(item -> item).map(mosaicInfoDTO -> new MosaicInfo(mosaicInfoDTO.getMeta().isActive(), mosaicInfoDTO.getMeta().getIndex(), mosaicInfoDTO.getMeta().getId(), new NamespaceId(mosaicInfoDTO.getMosaic().getNamespaceId().extractIntArray()), new MosaicId(mosaicInfoDTO.getMosaic().getMosaicId().extractIntArray()), mosaicInfoDTO.getMosaic().getSupply().extractIntArray(), mosaicInfoDTO.getMosaic().getHeight().extractIntArray(), new PublicAccount(mosaicInfoDTO.getMosaic().getOwner(), (NetworkType)((Object)networkType)), this.extractMosaicProperties(mosaicInfoDTO.getMosaic().getProperties()))).toList().toObservable());
    }

    @Override
    public Observable<List<MosaicName>> getMosaicNames(List<MosaicId> mosaicIds) {
        JsonObject requestBody = new JsonObject();
        requestBody.put("mosaicIds", mosaicIds.stream().map(id -> UInt64.bigIntegerToHex(id.getId())).collect(Collectors.toList()));
        return this.client.postAbs(this.url + "/mosaic/names").as(BodyCodec.jsonArray()).rxSendJson((Object)requestBody).toObservable().map(Http::mapJsonArrayOrError).map(json -> (List)this.objectMapper.readValue(json.toString(), (TypeReference)new TypeReference<List<MosaicNameDTO>>(){})).flatMapIterable(item -> item).map(mosaicNameDTO -> new MosaicName(new MosaicId(mosaicNameDTO.getMosaicId().extractIntArray()), mosaicNameDTO.getName(), new NamespaceId(mosaicNameDTO.getParentId().extractIntArray()))).toList().toObservable();
    }

    private MosaicProperties extractMosaicProperties(MosaicPropertiesDTO mosaicPropertiesDTO) {
        String flags = "00" + Integer.toBinaryString(((UInt64DTO)mosaicPropertiesDTO.get(0)).extractIntArray().intValue());
        String bitMapFlags = flags.substring(flags.length() - 3, flags.length());
        return new MosaicProperties(bitMapFlags.charAt(2) == '1', bitMapFlags.charAt(1) == '1', bitMapFlags.charAt(0) == '1', ((UInt64DTO)mosaicPropertiesDTO.get(1)).extractIntArray().intValue(), ((UInt64DTO)mosaicPropertiesDTO.get(2)).extractIntArray());
    }
}

