/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.nem.sdk.infrastructure.ListenerChannel;
import io.nem.sdk.infrastructure.ListenerMessage;
import io.nem.sdk.infrastructure.ListenerSubscribeMessage;
import io.nem.sdk.infrastructure.TransactionMapping;
import io.nem.sdk.infrastructure.UInt64DTO;
import io.nem.sdk.model.account.Address;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.BlockInfo;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.AggregateTransaction;
import io.nem.sdk.model.transaction.CosignatureSignedTransaction;
import io.nem.sdk.model.transaction.Deadline;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.model.transaction.TransactionStatusError;
import io.nem.sdk.model.transaction.TransferTransaction;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public class Listener {
    private final URL url;
    private final Subject<ListenerMessage> messageSubject;
    private String UID;
    private WebSocket webSocket;
    private ObjectMapper objectMapper = new ObjectMapper();

    public Listener(String url) throws MalformedURLException {
        this.url = new URL(url);
        this.messageSubject = PublishSubject.create();
    }

    public CompletableFuture<Void> open() {
        HttpClient httpClient = Vertx.vertx().createHttpClient();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.webSocket != null) {
            return CompletableFuture.completedFuture(null);
        }
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setHost(this.url.getHost());
        requestOptions.setPort(this.url.getPort());
        requestOptions.setURI("/ws");
        httpClient.websocket(requestOptions, webSocket -> {
            this.webSocket = webSocket;
            webSocket.handler(handler -> {
                JsonObject message = handler.toJsonObject();
                if (message.containsKey("uid")) {
                    this.UID = message.getString("uid");
                    future.complete(null);
                } else if (message.containsKey("transaction")) {
                    this.messageSubject.onNext((Object)new ListenerMessage(ListenerChannel.rawValueOf(message.getJsonObject("meta").getString("channelName")), new TransactionMapping().apply(message)));
                } else if (message.containsKey("block")) {
                    JsonObject meta = message.getJsonObject("meta");
                    JsonObject block = message.getJsonObject("block");
                    int rawNetworkType = (int)Long.parseLong(Integer.toHexString(block.getInteger("version")).substring(0, 2), 16);
                    NetworkType networkType = rawNetworkType == NetworkType.MIJIN_TEST.getValue() ? NetworkType.MIJIN_TEST : (rawNetworkType == NetworkType.MIJIN.getValue() ? NetworkType.MIJIN : (rawNetworkType == NetworkType.MAIN_NET.getValue() ? NetworkType.MAIN_NET : NetworkType.TEST_NET));
                    int version = (int)Long.parseLong(Integer.toHexString(block.getInteger("version")).substring(2, 4), 16);
                    this.messageSubject.onNext((Object)new ListenerMessage(ListenerChannel.BLOCK, new BlockInfo(meta.getString("hash"), meta.getString("generationHash"), Optional.empty(), Optional.empty(), block.getString("signature"), new PublicAccount(block.getString("signer"), networkType), networkType, version, block.getInteger("type"), this.extractBigInteger(block.getJsonArray("height")), this.extractBigInteger(block.getJsonArray("timestamp")), this.extractBigInteger(block.getJsonArray("difficulty")), block.getString("previousBlockHash"), block.getString("blockTransactionsHash"))));
                } else if (message.containsKey("status")) {
                    this.messageSubject.onNext((Object)new ListenerMessage(ListenerChannel.STATUS, new TransactionStatusError(message.getString("hash"), message.getString("status"), new Deadline(this.extractBigInteger(message.getJsonArray("deadline"))))));
                } else if (message.containsKey("meta")) {
                    this.messageSubject.onNext((Object)new ListenerMessage(ListenerChannel.rawValueOf(message.getJsonObject("meta").getString("channelName")), message.getJsonObject("meta").getString("hash")));
                } else if (message.containsKey("parentHash")) {
                    this.messageSubject.onNext((Object)new ListenerMessage(ListenerChannel.COSIGNATURE, new CosignatureSignedTransaction(message.getString("parenthash"), message.getString("signature"), message.getString("signer"))));
                }
            });
        });
        return future;
    }

    public String getUID() {
        return this.UID;
    }

    public void close() {
        this.webSocket.close();
    }

    public Observable<BlockInfo> newBlock() {
        this.subscribeTo(ListenerChannel.BLOCK.toString());
        return this.messageSubject.filter(rawMessage -> rawMessage.getChannel().equals((Object)ListenerChannel.BLOCK)).map(rawMessage -> (BlockInfo)rawMessage.getMessage());
    }

    public Observable<Transaction> confirmed(Address address) {
        this.subscribeTo(ListenerChannel.CONFIRMED_ADDED.toString() + "/" + address.plain());
        return this.messageSubject.filter(rawMessage -> rawMessage.getChannel().equals((Object)ListenerChannel.CONFIRMED_ADDED)).map(rawMessage -> (Transaction)rawMessage.getMessage()).filter(transaction -> this.transactionFromAddress((Transaction)transaction, address));
    }

    public Observable<Transaction> unconfirmedAdded(Address address) {
        this.subscribeTo((Object)((Object)ListenerChannel.UNCONFIRMED_ADDED) + "/" + address.plain());
        return this.messageSubject.filter(rawMessage -> rawMessage.getChannel().equals((Object)ListenerChannel.UNCONFIRMED_ADDED)).map(rawMessage -> (Transaction)rawMessage.getMessage()).filter(transaction -> this.transactionFromAddress((Transaction)transaction, address));
    }

    public Observable<String> unconfirmedRemoved(Address address) {
        this.subscribeTo((Object)((Object)ListenerChannel.UNCONFIRMED_REMOVED) + "/" + address.plain());
        return this.messageSubject.filter(rawMessage -> rawMessage.getChannel().equals((Object)ListenerChannel.UNCONFIRMED_REMOVED)).map(rawMessage -> (String)rawMessage.getMessage());
    }

    public Observable<AggregateTransaction> aggregateBondedAdded(Address address) {
        this.subscribeTo((Object)((Object)ListenerChannel.AGGREGATE_BONDED_ADDED) + "/" + address.plain());
        return this.messageSubject.filter(rawMessage -> rawMessage.getChannel().equals((Object)ListenerChannel.AGGREGATE_BONDED_ADDED)).map(rawMessage -> (AggregateTransaction)rawMessage.getMessage()).filter(transaction -> this.transactionFromAddress((Transaction)transaction, address));
    }

    public Observable<String> aggregateBondedRemoved(Address address) {
        this.subscribeTo((Object)((Object)ListenerChannel.AGGREGATE_BONDED_REMOVED) + "/" + address.plain());
        return this.messageSubject.filter(rawMessage -> rawMessage.getChannel().equals((Object)ListenerChannel.AGGREGATE_BONDED_REMOVED)).map(rawMessage -> (String)rawMessage.getMessage());
    }

    public Observable<TransactionStatusError> status(Address address) {
        this.subscribeTo((Object)((Object)ListenerChannel.STATUS) + "/" + address.plain());
        return this.messageSubject.filter(rawMessage -> rawMessage.getChannel().equals((Object)ListenerChannel.STATUS)).map(rawMessage -> (TransactionStatusError)rawMessage.getMessage());
    }

    public Observable<CosignatureSignedTransaction> cosignatureAdded(Address address) {
        this.subscribeTo((Object)((Object)ListenerChannel.CONFIRMED_ADDED) + "/" + address.plain());
        return this.messageSubject.filter(rawMessage -> rawMessage.getChannel().equals((Object)ListenerChannel.COSIGNATURE)).map(rawMessage -> (CosignatureSignedTransaction)rawMessage.getMessage());
    }

    private void subscribeTo(String channel) {
        String json;
        ListenerSubscribeMessage subscribeMessage = new ListenerSubscribeMessage(this.UID, channel);
        try {
            json = this.objectMapper.writeValueAsString((Object)subscribeMessage);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e.getCause());
        }
        this.webSocket.writeTextMessage(json);
    }

    private BigInteger extractBigInteger(JsonArray input) {
        UInt64DTO uInt64DTO = new UInt64DTO();
        input.stream().forEach(item -> uInt64DTO.add(new Long(item.toString())));
        return uInt64DTO.extractIntArray();
    }

    private boolean transactionFromAddress(Transaction transaction, Address address) {
        AtomicBoolean transactionFromAddress = new AtomicBoolean(this.transactionHasSignerOrReceptor(transaction, address));
        if (transaction instanceof AggregateTransaction) {
            AggregateTransaction aggregateTransaction = (AggregateTransaction)transaction;
            aggregateTransaction.getCosignatures().forEach(cosignature -> {
                if (cosignature.getSigner().getAddress().equals(address)) {
                    transactionFromAddress.set(true);
                }
            });
            aggregateTransaction.getInnerTransactions().forEach(innerTransaction -> {
                if (this.transactionHasSignerOrReceptor((Transaction)innerTransaction, address)) {
                    transactionFromAddress.set(true);
                }
            });
        }
        return transactionFromAddress.get();
    }

    private boolean transactionHasSignerOrReceptor(Transaction transaction, Address address) {
        boolean isReceptor = false;
        if (transaction instanceof TransferTransaction) {
            isReceptor = ((TransferTransaction)transaction).getRecipient().equals(address);
        }
        return transaction.getSigner().get().getAddress().equals(address) || isReceptor;
    }
}

