/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CircularStack<E>
implements Iterable<E> {
    private final List<E> elements;
    private final int limit;

    public CircularStack(int limit) {
        this.elements = new ArrayList(limit);
        this.limit = limit;
    }

    public void shallowCopyTo(CircularStack<E> destination) {
        destination.elements.clear();
        super.pushAll(this);
    }

    private void pushAll(CircularStack<E> rhs) {
        int i = 0;
        for (E element : rhs) {
            if (i >= rhs.size() - this.limit) {
                this.push(element);
            }
            ++i;
        }
    }

    public void push(E element) {
        this.elements.add(element);
        if (this.elements.size() > this.limit) {
            this.elements.remove(0);
        }
    }

    public E peek() {
        return this.elements.get(this.elements.size() - 1);
    }

    public void pop() {
        this.elements.remove(this.elements.size() - 1);
    }

    public int size() {
        return this.elements.size();
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.iterator();
    }
}

