/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.utils;

import io.nem.core.utils.ByteUtils;
import java.math.BigInteger;

public class ArrayUtils {
    public static byte[] duplicate(byte[] src) {
        byte[] result = new byte[src.length];
        System.arraycopy(src, 0, result, 0, src.length);
        return result;
    }

    public static byte[] concat(byte[] ... arrays) {
        int totalSize = 0;
        for (byte[] array : arrays) {
            totalSize += array.length;
        }
        int startIndex = 0;
        byte[] result = new byte[totalSize];
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, result, startIndex, array.length);
            startIndex += array.length;
        }
        return result;
    }

    public static byte[][] split(byte[] bytes, int splitIndex) {
        if (splitIndex < 0 || bytes.length < splitIndex) {
            throw new IllegalArgumentException("split index is out of range");
        }
        byte[] lhs = new byte[splitIndex];
        byte[] rhs = new byte[bytes.length - splitIndex];
        System.arraycopy(bytes, 0, lhs, 0, lhs.length);
        System.arraycopy(bytes, splitIndex, rhs, 0, rhs.length);
        return new byte[][]{lhs, rhs};
    }

    public static byte[] toByteArray(BigInteger value, int numBytes) {
        byte[] bigIntegerBytes;
        byte[] outputBytes = new byte[numBytes];
        int copyStartIndex = 0 == (bigIntegerBytes = value.toByteArray())[0] ? 1 : 0;
        int numBytesToCopy = bigIntegerBytes.length - copyStartIndex;
        if (numBytesToCopy > numBytes) {
            copyStartIndex += numBytesToCopy - numBytes;
            numBytesToCopy = numBytes;
        }
        for (int i = 0; i < numBytesToCopy; ++i) {
            outputBytes[i] = bigIntegerBytes[copyStartIndex + numBytesToCopy - i - 1];
        }
        return outputBytes;
    }

    public static BigInteger toBigInteger(byte[] bytes) {
        byte[] bigEndianBytes = new byte[bytes.length + 1];
        for (int i = 0; i < bytes.length; ++i) {
            bigEndianBytes[i + 1] = bytes[bytes.length - i - 1];
        }
        return new BigInteger(bigEndianBytes);
    }

    public static int isEqualConstantTime(byte[] b, byte[] c) {
        int result = 0;
        result |= b.length - c.length;
        for (int i = 0; i < b.length; ++i) {
            result |= b[i] ^ c[i];
        }
        return ByteUtils.isEqualConstantTime(result, 0);
    }

    public static int compare(byte[] b, byte[] c) {
        int result = b.length - c.length;
        if (0 != result) {
            return result;
        }
        for (int i = 0; i < b.length; ++i) {
            result = b[i] - c[i];
            if (0 == result) continue;
            return result;
        }
        return 0;
    }

    public static int getBit(byte[] h, int i) {
        return h[i >> 3] >> (i & 7) & 1;
    }
}

