/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.utils;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractTwoLevelMap<TKey, TValue> {
    private final Map<TKey, Map<TKey, TValue>> impl = new ConcurrentHashMap<TKey, Map<TKey, TValue>>();

    public TValue getItem(TKey key1, TKey key2) {
        Map<TKey, TValue> keyOneValues = this.getItems(key1);
        TValue value = keyOneValues.get(key2);
        if (null == value) {
            value = this.createValue();
            keyOneValues.put(key2, value);
        }
        return value;
    }

    public Map<TKey, TValue> getItems(TKey key) {
        Map<TKey, TValue> keyValues = this.impl.get(key);
        if (null == keyValues) {
            keyValues = new ConcurrentHashMap<TKey, TValue>();
            this.impl.put(key, keyValues);
        }
        return keyValues;
    }

    public void remove(TKey key) {
        this.impl.remove(key);
    }

    public Set<TKey> keySet() {
        return this.impl.keySet();
    }

    protected abstract TValue createValue();
}

