/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.math;

import io.nem.core.math.ColumnVector;
import io.nem.core.math.MatrixNonZeroElementRowIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleUnaryOperator;

public abstract class Matrix {
    private final int numRows;
    private final int numCols;

    protected Matrix(int numRows, int numCols) {
        this.numRows = numRows;
        this.numCols = numCols;
    }

    public final int getElementCount() {
        return this.numRows * this.numCols;
    }

    public final int getRowCount() {
        return this.numRows;
    }

    public final int getColumnCount() {
        return this.numCols;
    }

    public final double getAt(int row, int col) {
        this.checkBounds(row, col);
        return this.getAtUnchecked(row, col);
    }

    public final void setAt(int row, int col, double val) {
        this.checkBounds(row, col);
        this.setAtUnchecked(row, col, val);
    }

    public final void incrementAt(int row, int col, double val) {
        double originalVal = this.getAt(row, col);
        this.setAtUnchecked(row, col, originalVal + val);
    }

    public final ColumnVector getRowSumVector() {
        double[] sums = new double[this.numRows];
        this.forEach((int r, int c, double v) -> {
            int n = r;
            sums[n] = sums[n] + v;
        });
        return new ColumnVector(sums);
    }

    public final ColumnVector getColumnSumVector() {
        return new ColumnVector(this.getColumnSums(v -> v));
    }

    private double[] getColumnSums(DoubleUnaryOperator op) {
        double[] sums = new double[this.numCols];
        this.forEach((int r, int c, double v) -> {
            int n = c;
            sums[n] = sums[n] + op.applyAsDouble(v);
        });
        return sums;
    }

    public Collection<Integer> normalizeColumns() {
        double[] columnSums = this.getColumnSums(Math::abs);
        ArrayList<Integer> zeroColumns = new ArrayList<Integer>();
        for (int i = 0; i < this.numCols; ++i) {
            if (0.0 != columnSums[i]) continue;
            zeroColumns.add(i);
        }
        this.forEach((int row, int col, double value, DoubleConsumer setter) -> {
            double sum = columnSums[col];
            if (0.0 == sum) {
                return;
            }
            setter.accept(value / sum);
        });
        return zeroColumns;
    }

    public void removeNegatives() {
        this.removeLessThan(0.0);
    }

    public void removeLessThan(double minValue) {
        this.forEach((int row, int col, double value, DoubleConsumer setter) -> {
            if (value < minValue) {
                setter.accept(0.0);
            }
        });
    }

    public final void scale(double scale) {
        this.forEach((int row, int col, double value, DoubleConsumer setter) -> setter.accept(value / scale));
    }

    public Matrix multiplyElementWise(Matrix matrix) {
        return this.join(matrix, false, (l, r) -> l * r);
    }

    public Matrix addElementWise(Matrix matrix) {
        return this.join(matrix, true, (l, r) -> l + r);
    }

    private Matrix join(Matrix matrix, boolean isTwoWay, DoubleBinaryOperator op) {
        if (!this.isSameSize(matrix)) {
            throw new IllegalArgumentException("matrix sizes must be equal");
        }
        Matrix result = this.create(this.getRowCount(), this.getColumnCount());
        this.forEach((int r, int c, double v) -> result.setAtUnchecked(r, c, op.applyAsDouble(v, matrix.getAtUnchecked(r, c))));
        if (isTwoWay) {
            matrix.forEach((int r, int c, double v) -> result.setAtUnchecked(r, c, op.applyAsDouble(v, this.getAtUnchecked(r, c))));
        }
        return result;
    }

    public final double absSum() {
        return this.aggregate(Math::abs);
    }

    public final double sum() {
        return this.aggregate(v -> v);
    }

    private double aggregate(DoubleUnaryOperator op) {
        double[] sum = new double[]{0.0};
        this.forEach((int r, int c, double v) -> {
            sum[0] = sum[0] + op.applyAsDouble(v);
        });
        return sum[0];
    }

    public ColumnVector multiply(ColumnVector vector) {
        if (this.numCols != vector.size()) {
            throw new IllegalArgumentException("vector size and matrix column count must be equal");
        }
        double[] rawResult = new double[this.numRows];
        double[] rawVector = vector.getRaw();
        this.forEach((int r, int c, double v) -> {
            int n = r;
            rawResult[n] = rawResult[n] + v * rawVector[c];
        });
        return new ColumnVector(rawResult);
    }

    public final Matrix transpose() {
        Matrix transposedMatrix = this.create(this.getColumnCount(), this.getRowCount());
        this.forEach((int r, int c, double v) -> transposedMatrix.setAtUnchecked(c, r, v));
        return transposedMatrix;
    }

    public Matrix roundTo(int numPlaces) {
        double multipler = Math.pow(10.0, numPlaces);
        return this.transform(v -> (double)Math.round(v * multipler) / multipler);
    }

    public Matrix multiply(double scalar) {
        return this.transform(v -> v * scalar);
    }

    public Matrix add(double scalar) {
        return this.transform(v -> v + scalar);
    }

    public Matrix abs() {
        return this.transform(Math::abs);
    }

    public Matrix sqrt() {
        return this.transform(Math::sqrt);
    }

    private Matrix transform(DoubleUnaryOperator op) {
        Matrix matrix = this.create(this.getRowCount(), this.getColumnCount());
        this.forEach((int r, int c, double v) -> matrix.setAtUnchecked(r, c, op.applyAsDouble(v)));
        return matrix;
    }

    public final boolean isSameSize(Matrix matrix) {
        return this.numRows == matrix.numRows && this.numCols == matrix.numCols;
    }

    private void checkBounds(int row, int col) {
        if (row < 0 || row >= this.numRows) {
            throw new IndexOutOfBoundsException("Row index out of bounds");
        }
        if (col < 0 || col >= this.numCols) {
            throw new IndexOutOfBoundsException("Column index out of bounds");
        }
    }

    public final boolean isZeroMatrix() {
        return 0.0 == this.absSum();
    }

    public int hashCode() {
        return this.getRowCount() ^ this.getColumnCount();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Matrix)) {
            return false;
        }
        Matrix rhs = (Matrix)obj;
        if (!this.isSameSize(rhs)) {
            return false;
        }
        Matrix inequalityMatrix = this.join(rhs, true, (l, r) -> l == r ? 0.0 : 1.0);
        return 0.0 == inequalityMatrix.sum();
    }

    public void forEach(ReadOnlyElementVisitorFunction func) {
        this.forEach((int row, int col, double value, DoubleConsumer setter) -> func.visit(row, col, value));
    }

    protected abstract Matrix create(int var1, int var2);

    protected abstract double getAtUnchecked(int var1, int var2);

    protected abstract void setAtUnchecked(int var1, int var2, double var3);

    protected abstract void forEach(ElementVisitorFunction var1);

    public abstract MatrixNonZeroElementRowIterator getNonZeroElementRowIterator(int var1);

    @FunctionalInterface
    protected static interface ElementVisitorFunction {
        public void visit(int var1, int var2, double var3, DoubleConsumer var5);
    }

    @FunctionalInterface
    public static interface ReadOnlyElementVisitorFunction {
        public void visit(int var1, int var2, double var3);
    }
}

