/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.crypto.ed25519.arithmetic;

import io.nem.core.crypto.ed25519.arithmetic.CoordinateSystem;
import io.nem.core.crypto.ed25519.arithmetic.Ed25519EncodedFieldElement;
import io.nem.core.crypto.ed25519.arithmetic.Ed25519EncodedGroupElement;
import io.nem.core.crypto.ed25519.arithmetic.Ed25519Field;
import io.nem.core.crypto.ed25519.arithmetic.Ed25519FieldElement;
import io.nem.core.crypto.ed25519.arithmetic.Ed25519Group;
import io.nem.core.utils.ByteUtils;
import java.io.Serializable;

public class Ed25519GroupElement
implements Serializable {
    private final CoordinateSystem coordinateSystem;
    private final Ed25519FieldElement X;
    private final Ed25519FieldElement Y;
    private final Ed25519FieldElement Z;
    private final Ed25519FieldElement T;
    private Ed25519GroupElement[][] precomputedForSingle;
    private Ed25519GroupElement[] precomputedForDouble;

    public Ed25519GroupElement(CoordinateSystem coordinateSystem, Ed25519FieldElement X, Ed25519FieldElement Y, Ed25519FieldElement Z, Ed25519FieldElement T) {
        this.coordinateSystem = coordinateSystem;
        this.X = X;
        this.Y = Y;
        this.Z = Z;
        this.T = T;
    }

    public static Ed25519GroupElement affine(Ed25519FieldElement x, Ed25519FieldElement y, Ed25519FieldElement Z) {
        return new Ed25519GroupElement(CoordinateSystem.AFFINE, x, y, Z, null);
    }

    public static Ed25519GroupElement p2(Ed25519FieldElement X, Ed25519FieldElement Y, Ed25519FieldElement Z) {
        return new Ed25519GroupElement(CoordinateSystem.P2, X, Y, Z, null);
    }

    public static Ed25519GroupElement p3(Ed25519FieldElement X, Ed25519FieldElement Y, Ed25519FieldElement Z, Ed25519FieldElement T) {
        return new Ed25519GroupElement(CoordinateSystem.P3, X, Y, Z, T);
    }

    public static Ed25519GroupElement p1xp1(Ed25519FieldElement X, Ed25519FieldElement Y, Ed25519FieldElement Z, Ed25519FieldElement T) {
        return new Ed25519GroupElement(CoordinateSystem.P1xP1, X, Y, Z, T);
    }

    public static Ed25519GroupElement precomputed(Ed25519FieldElement yPlusx, Ed25519FieldElement yMinusx, Ed25519FieldElement xy2d) {
        return new Ed25519GroupElement(CoordinateSystem.PRECOMPUTED, yPlusx, yMinusx, xy2d, null);
    }

    public static Ed25519GroupElement cached(Ed25519FieldElement YPlusX, Ed25519FieldElement YMinusX, Ed25519FieldElement Z, Ed25519FieldElement T2d) {
        return new Ed25519GroupElement(CoordinateSystem.CACHED, YPlusX, YMinusX, Z, T2d);
    }

    private static byte[] toRadix16(Ed25519EncodedFieldElement encoded) {
        int i;
        byte[] a = encoded.getRaw();
        byte[] e = new byte[64];
        for (i = 0; i < 32; ++i) {
            e[2 * i] = (byte)(a[i] & 0xF);
            e[2 * i + 1] = (byte)(a[i] >> 4 & 0xF);
        }
        int carry = 0;
        i = 0;
        while (i < 63) {
            int n = i;
            e[n] = (byte)(e[n] + carry);
            carry = e[i] + 8;
            int n2 = i++;
            e[n2] = (byte)(e[n2] - ((carry >>= 4) << 4));
        }
        e[63] = (byte)(e[63] + carry);
        return e;
    }

    private static byte[] slide(Ed25519EncodedFieldElement encoded) {
        int i;
        byte[] a = encoded.getRaw();
        byte[] r = new byte[256];
        for (i = 0; i < 256; ++i) {
            r[i] = (byte)(1 & a[i >> 3] >> (i & 7));
        }
        block1: for (i = 0; i < 256; ++i) {
            if (r[i] == 0) continue;
            block2: for (int b = 1; b <= 6 && i + b < 256; ++b) {
                if (r[i + b] == 0) continue;
                if (r[i] + (r[i + b] << b) <= 15) {
                    int n = i;
                    r[n] = (byte)(r[n] + (r[i + b] << b));
                    r[i + b] = 0;
                    continue;
                }
                if (r[i] - (r[i + b] << b) < -15) continue block1;
                int n = i;
                r[n] = (byte)(r[n] - (r[i + b] << b));
                for (int k = i + b; k < 256; ++k) {
                    if (r[k] == 0) {
                        r[k] = 1;
                        continue block2;
                    }
                    r[k] = 0;
                }
            }
        }
        return r;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public Ed25519FieldElement getX() {
        return this.X;
    }

    public Ed25519FieldElement getY() {
        return this.Y;
    }

    public Ed25519FieldElement getZ() {
        return this.Z;
    }

    public Ed25519FieldElement getT() {
        return this.T;
    }

    public boolean isPrecomputedForDoubleScalarMultiplication() {
        return null != this.precomputedForDouble;
    }

    public Ed25519GroupElement[][] getPrecomputedForSingle() {
        return this.precomputedForSingle;
    }

    public Ed25519GroupElement[] getPrecomputedForDouble() {
        return this.precomputedForDouble;
    }

    public Ed25519EncodedGroupElement encode() {
        switch (this.coordinateSystem) {
            case P2: 
            case P3: {
                Ed25519FieldElement inverse = this.Z.invert();
                Ed25519FieldElement x = this.X.multiply(inverse);
                Ed25519FieldElement y = this.Y.multiply(inverse);
                byte[] s = y.encode().getRaw();
                int n = s.length - 1;
                s[n] = (byte)(s[n] | (x.isNegative() ? -128 : 0));
                return new Ed25519EncodedGroupElement(s);
            }
        }
        return this.toP2().encode();
    }

    public Ed25519GroupElement toP2() {
        return this.toCoordinateSystem(CoordinateSystem.P2);
    }

    public Ed25519GroupElement toP3() {
        return this.toCoordinateSystem(CoordinateSystem.P3);
    }

    public Ed25519GroupElement toCached() {
        return this.toCoordinateSystem(CoordinateSystem.CACHED);
    }

    private Ed25519GroupElement toCoordinateSystem(CoordinateSystem newCoordinateSystem) {
        switch (this.coordinateSystem) {
            case P2: {
                switch (newCoordinateSystem) {
                    case P2: {
                        return Ed25519GroupElement.p2(this.X, this.Y, this.Z);
                    }
                }
                throw new IllegalArgumentException();
            }
            case P3: {
                switch (newCoordinateSystem) {
                    case P2: {
                        return Ed25519GroupElement.p2(this.X, this.Y, this.Z);
                    }
                    case P3: {
                        return Ed25519GroupElement.p3(this.X, this.Y, this.Z, this.T);
                    }
                    case CACHED: {
                        return Ed25519GroupElement.cached(this.Y.add(this.X), this.Y.subtract(this.X), this.Z, this.T.multiply(Ed25519Field.D_Times_TWO));
                    }
                }
                throw new IllegalArgumentException();
            }
            case P1xP1: {
                switch (newCoordinateSystem) {
                    case P2: {
                        return Ed25519GroupElement.p2(this.X.multiply(this.T), this.Y.multiply(this.Z), this.Z.multiply(this.T));
                    }
                    case P3: {
                        return Ed25519GroupElement.p3(this.X.multiply(this.T), this.Y.multiply(this.Z), this.Z.multiply(this.T), this.X.multiply(this.Y));
                    }
                    case P1xP1: {
                        return Ed25519GroupElement.p1xp1(this.X, this.Y, this.Z, this.T);
                    }
                }
                throw new IllegalArgumentException();
            }
            case PRECOMPUTED: {
                switch (newCoordinateSystem) {
                    case PRECOMPUTED: {
                        return Ed25519GroupElement.precomputed(this.X, this.Y, this.Z);
                    }
                }
                throw new IllegalArgumentException();
            }
            case CACHED: {
                switch (newCoordinateSystem) {
                    case CACHED: {
                        return Ed25519GroupElement.cached(this.X, this.Y, this.Z, this.T);
                    }
                }
                throw new IllegalArgumentException();
            }
        }
        throw new UnsupportedOperationException();
    }

    public void precomputeForScalarMultiplication() {
        if (null != this.precomputedForSingle) {
            return;
        }
        Ed25519GroupElement Bi = this;
        this.precomputedForSingle = new Ed25519GroupElement[32][8];
        for (int i = 0; i < 32; ++i) {
            Ed25519GroupElement Bij = Bi;
            for (int j = 0; j < 8; ++j) {
                Ed25519FieldElement inverse = Bij.Z.invert();
                Ed25519FieldElement x = Bij.X.multiply(inverse);
                Ed25519FieldElement y = Bij.Y.multiply(inverse);
                this.precomputedForSingle[i][j] = Ed25519GroupElement.precomputed(y.add(x), y.subtract(x), x.multiply(y).multiply(Ed25519Field.D_Times_TWO));
                Bij = Bij.add(Bi.toCached()).toP3();
            }
            for (int k = 0; k < 8; ++k) {
                Bi = Bi.add(Bi.toCached()).toP3();
            }
        }
    }

    public void precomputeForDoubleScalarMultiplication() {
        if (null != this.precomputedForDouble) {
            return;
        }
        Ed25519GroupElement Bi = this;
        this.precomputedForDouble = new Ed25519GroupElement[8];
        for (int i = 0; i < 8; ++i) {
            Ed25519FieldElement inverse = Bi.Z.invert();
            Ed25519FieldElement x = Bi.X.multiply(inverse);
            Ed25519FieldElement y = Bi.Y.multiply(inverse);
            this.precomputedForDouble[i] = Ed25519GroupElement.precomputed(y.add(x), y.subtract(x), x.multiply(y).multiply(Ed25519Field.D_Times_TWO));
            Bi = this.add(this.add(Bi.toCached()).toP3().toCached()).toP3();
        }
    }

    public Ed25519GroupElement dbl() {
        switch (this.coordinateSystem) {
            case P2: 
            case P3: {
                Ed25519FieldElement XSquare = this.X.square();
                Ed25519FieldElement YSquare = this.Y.square();
                Ed25519FieldElement B = this.Z.squareAndDouble();
                Ed25519FieldElement A = this.X.add(this.Y);
                Ed25519FieldElement ASquare = A.square();
                Ed25519FieldElement YSquarePlusXSquare = YSquare.add(XSquare);
                Ed25519FieldElement YSquareMinusXSquare = YSquare.subtract(XSquare);
                return Ed25519GroupElement.p1xp1(ASquare.subtract(YSquarePlusXSquare), YSquarePlusXSquare, YSquareMinusXSquare, B.subtract(YSquareMinusXSquare));
            }
        }
        throw new UnsupportedOperationException();
    }

    private Ed25519GroupElement precomputedAdd(Ed25519GroupElement g) {
        if (this.coordinateSystem != CoordinateSystem.P3) {
            throw new UnsupportedOperationException();
        }
        if (g.coordinateSystem != CoordinateSystem.PRECOMPUTED) {
            throw new IllegalArgumentException();
        }
        Ed25519FieldElement YPlusX = this.Y.add(this.X);
        Ed25519FieldElement YMinusX = this.Y.subtract(this.X);
        Ed25519FieldElement A = YPlusX.multiply(g.X);
        Ed25519FieldElement B = YMinusX.multiply(g.Y);
        Ed25519FieldElement C = g.Z.multiply(this.T);
        Ed25519FieldElement D = this.Z.add(this.Z);
        return Ed25519GroupElement.p1xp1(A.subtract(B), A.add(B), D.add(C), D.subtract(C));
    }

    private Ed25519GroupElement precomputedSubtract(Ed25519GroupElement g) {
        if (this.coordinateSystem != CoordinateSystem.P3) {
            throw new UnsupportedOperationException();
        }
        if (g.coordinateSystem != CoordinateSystem.PRECOMPUTED) {
            throw new IllegalArgumentException();
        }
        Ed25519FieldElement YPlusX = this.Y.add(this.X);
        Ed25519FieldElement YMinusX = this.Y.subtract(this.X);
        Ed25519FieldElement A = YPlusX.multiply(g.Y);
        Ed25519FieldElement B = YMinusX.multiply(g.X);
        Ed25519FieldElement C = g.Z.multiply(this.T);
        Ed25519FieldElement D = this.Z.add(this.Z);
        return Ed25519GroupElement.p1xp1(A.subtract(B), A.add(B), D.subtract(C), D.add(C));
    }

    public Ed25519GroupElement add(Ed25519GroupElement g) {
        if (this.coordinateSystem != CoordinateSystem.P3) {
            throw new UnsupportedOperationException();
        }
        if (g.coordinateSystem != CoordinateSystem.CACHED) {
            throw new IllegalArgumentException();
        }
        Ed25519FieldElement YPlusX = this.Y.add(this.X);
        Ed25519FieldElement YMinusX = this.Y.subtract(this.X);
        Ed25519FieldElement A = YPlusX.multiply(g.X);
        Ed25519FieldElement B = YMinusX.multiply(g.Y);
        Ed25519FieldElement C = g.T.multiply(this.T);
        Ed25519FieldElement ZSquare = this.Z.multiply(g.Z);
        Ed25519FieldElement D = ZSquare.add(ZSquare);
        return Ed25519GroupElement.p1xp1(A.subtract(B), A.add(B), D.add(C), D.subtract(C));
    }

    public Ed25519GroupElement subtract(Ed25519GroupElement g) {
        if (this.coordinateSystem != CoordinateSystem.P3) {
            throw new UnsupportedOperationException();
        }
        if (g.coordinateSystem != CoordinateSystem.CACHED) {
            throw new IllegalArgumentException();
        }
        Ed25519FieldElement YPlusX = this.Y.add(this.X);
        Ed25519FieldElement YMinusX = this.Y.subtract(this.X);
        Ed25519FieldElement A = YPlusX.multiply(g.Y);
        Ed25519FieldElement B = YMinusX.multiply(g.X);
        Ed25519FieldElement C = g.T.multiply(this.T);
        Ed25519FieldElement ZSquare = this.Z.multiply(g.Z);
        Ed25519FieldElement D = ZSquare.add(ZSquare);
        return Ed25519GroupElement.p1xp1(A.subtract(B), A.add(B), D.subtract(C), D.add(C));
    }

    public Ed25519GroupElement negate() {
        if (this.coordinateSystem != CoordinateSystem.P3) {
            throw new UnsupportedOperationException();
        }
        return Ed25519Group.ZERO_P3.subtract(this.toCached()).toP3();
    }

    public int hashCode() {
        return this.encode().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Ed25519GroupElement)) {
            return false;
        }
        Ed25519GroupElement ge = (Ed25519GroupElement)obj;
        if (!this.coordinateSystem.equals((Object)ge.coordinateSystem)) {
            try {
                ge = ge.toCoordinateSystem(this.coordinateSystem);
            }
            catch (Exception e) {
                return false;
            }
        }
        switch (this.coordinateSystem) {
            case P2: 
            case P3: {
                if (this.Z.equals(ge.Z)) {
                    return this.X.equals(ge.X) && this.Y.equals(ge.Y);
                }
                Ed25519FieldElement x1 = this.X.multiply(ge.Z);
                Ed25519FieldElement y1 = this.Y.multiply(ge.Z);
                Ed25519FieldElement x2 = ge.X.multiply(this.Z);
                Ed25519FieldElement y2 = ge.Y.multiply(this.Z);
                return x1.equals(x2) && y1.equals(y2);
            }
            case P1xP1: {
                return this.toP2().equals(ge);
            }
            case PRECOMPUTED: {
                return this.X.equals(ge.X) && this.Y.equals(ge.Y) && this.Z.equals(ge.Z);
            }
            case CACHED: {
                if (this.Z.equals(ge.Z)) {
                    return this.X.equals(ge.X) && this.Y.equals(ge.Y) && this.T.equals(ge.T);
                }
                Ed25519FieldElement x3 = this.X.multiply(ge.Z);
                Ed25519FieldElement y3 = this.Y.multiply(ge.Z);
                Ed25519FieldElement t3 = this.T.multiply(ge.Z);
                Ed25519FieldElement x4 = ge.X.multiply(this.Z);
                Ed25519FieldElement y4 = ge.Y.multiply(this.Z);
                Ed25519FieldElement t4 = ge.T.multiply(this.Z);
                return x3.equals(x4) && y3.equals(y4) && t3.equals(t4);
            }
        }
        return false;
    }

    private Ed25519GroupElement cmov(Ed25519GroupElement u, int b) {
        int i;
        Ed25519GroupElement ret = null;
        for (i = 0; i < b; ++i) {
            ret = u;
        }
        for (i = 0; i < 1 - b; ++i) {
            ret = this;
        }
        return ret;
    }

    private Ed25519GroupElement select(int pos, int b) {
        int bNegative = ByteUtils.isNegativeConstantTime(b);
        int bAbs = b - ((-bNegative & b) << 1);
        Ed25519GroupElement t = Ed25519Group.ZERO_PRECOMPUTED.cmov(this.precomputedForSingle[pos][0], ByteUtils.isEqualConstantTime(bAbs, 1)).cmov(this.precomputedForSingle[pos][1], ByteUtils.isEqualConstantTime(bAbs, 2)).cmov(this.precomputedForSingle[pos][2], ByteUtils.isEqualConstantTime(bAbs, 3)).cmov(this.precomputedForSingle[pos][3], ByteUtils.isEqualConstantTime(bAbs, 4)).cmov(this.precomputedForSingle[pos][4], ByteUtils.isEqualConstantTime(bAbs, 5)).cmov(this.precomputedForSingle[pos][5], ByteUtils.isEqualConstantTime(bAbs, 6)).cmov(this.precomputedForSingle[pos][6], ByteUtils.isEqualConstantTime(bAbs, 7)).cmov(this.precomputedForSingle[pos][7], ByteUtils.isEqualConstantTime(bAbs, 8));
        Ed25519GroupElement tMinus = Ed25519GroupElement.precomputed(t.Y, t.X, t.Z.negate());
        return t.cmov(tMinus, bNegative);
    }

    public Ed25519GroupElement scalarMultiply(Ed25519EncodedFieldElement a) {
        Ed25519GroupElement g;
        int i;
        byte[] e = Ed25519GroupElement.toRadix16(a);
        Ed25519GroupElement h = Ed25519Group.ZERO_P3;
        for (i = 1; i < 64; i += 2) {
            g = this.select(i / 2, e[i]);
            h = h.precomputedAdd(g).toP3();
        }
        h = h.dbl().toP2().dbl().toP2().dbl().toP2().dbl().toP3();
        for (i = 0; i < 64; i += 2) {
            g = this.select(i / 2, e[i]);
            h = h.precomputedAdd(g).toP3();
        }
        return h;
    }

    public Ed25519GroupElement doubleScalarMultiplyVariableTime(Ed25519GroupElement A, Ed25519EncodedFieldElement a, Ed25519EncodedFieldElement b) {
        int i;
        byte[] aSlide = Ed25519GroupElement.slide(a);
        byte[] bSlide = Ed25519GroupElement.slide(b);
        Ed25519GroupElement r = Ed25519Group.ZERO_P2;
        for (i = 255; i >= 0 && aSlide[i] == 0 && bSlide[i] == 0; --i) {
        }
        while (i >= 0) {
            Ed25519GroupElement t = r.dbl();
            if (aSlide[i] > 0) {
                t = t.toP3().precomputedSubtract(A.precomputedForDouble[aSlide[i] / 2]);
            } else if (aSlide[i] < 0) {
                t = t.toP3().precomputedAdd(A.precomputedForDouble[-aSlide[i] / 2]);
            }
            if (bSlide[i] > 0) {
                t = t.toP3().precomputedAdd(this.precomputedForDouble[bSlide[i] / 2]);
            } else if (bSlide[i] < 0) {
                t = t.toP3().precomputedSubtract(this.precomputedForDouble[-bSlide[i] / 2]);
            }
            r = t.toP2();
            --i;
        }
        return r;
    }

    public boolean satisfiesCurveEquation() {
        switch (this.coordinateSystem) {
            case P2: 
            case P3: {
                Ed25519FieldElement inverse = this.Z.invert();
                Ed25519FieldElement x = this.X.multiply(inverse);
                Ed25519FieldElement y = this.Y.multiply(inverse);
                Ed25519FieldElement xSquare = x.square();
                Ed25519FieldElement ySquare = y.square();
                Ed25519FieldElement dXSquareYSquare = Ed25519Field.D.multiply(xSquare).multiply(ySquare);
                return Ed25519Field.ONE.add(dXSquareYSquare).add(xSquare).equals(ySquare);
            }
        }
        return this.toP2().satisfiesCurveEquation();
    }

    public String toString() {
        return String.format("X=%s\nY=%s\nZ=%s\nT=%s\n", this.X.toString(), this.Y.toString(), this.Z.toString(), this.T.toString());
    }
}

