/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.crypto.ed25519.arithmetic;

import io.nem.core.crypto.ed25519.arithmetic.Ed25519EncodedFieldElement;
import io.nem.core.crypto.ed25519.arithmetic.Ed25519Field;
import io.nem.core.crypto.ed25519.arithmetic.Ed25519FieldElement;
import io.nem.core.crypto.ed25519.arithmetic.Ed25519GroupElement;
import io.nem.core.utils.ArrayUtils;
import java.util.Arrays;

public class Ed25519EncodedGroupElement {
    private final byte[] values;

    public Ed25519EncodedGroupElement(byte[] values) {
        if (32 != values.length) {
            throw new IllegalArgumentException("Invalid encoded group element.");
        }
        this.values = values;
    }

    public byte[] getRaw() {
        return this.values;
    }

    public Ed25519GroupElement decode() {
        Ed25519FieldElement x = this.getAffineX();
        Ed25519FieldElement y = this.getAffineY();
        return Ed25519GroupElement.p3(x, y, Ed25519Field.ONE, x.multiply(y));
    }

    public Ed25519FieldElement getAffineX() {
        Ed25519FieldElement v;
        Ed25519FieldElement y = this.getAffineY();
        Ed25519FieldElement ySquare = y.square();
        Ed25519FieldElement u = ySquare.subtract(Ed25519Field.ONE);
        Ed25519FieldElement x = Ed25519FieldElement.sqrt(u, v = ySquare.multiply(Ed25519Field.D).add(Ed25519Field.ONE));
        Ed25519FieldElement vxSquare = x.square().multiply(v);
        Ed25519FieldElement checkForZero = vxSquare.subtract(u);
        if (checkForZero.isNonZero()) {
            checkForZero = vxSquare.add(u);
            if (checkForZero.isNonZero()) {
                throw new IllegalArgumentException("not a valid Ed25519EncodedGroupElement.");
            }
            x = x.multiply(Ed25519Field.I);
        }
        if ((x.isNegative() ? 1 : 0) != ArrayUtils.getBit(this.values, 255)) {
            x = x.negate();
        }
        return x;
    }

    public Ed25519FieldElement getAffineY() {
        Ed25519EncodedFieldElement encoded = new Ed25519EncodedFieldElement(this.values);
        return encoded.decode();
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Ed25519EncodedGroupElement)) {
            return false;
        }
        Ed25519EncodedGroupElement encoded = (Ed25519EncodedGroupElement)obj;
        return 1 == ArrayUtils.isEqualConstantTime(this.values, encoded.values);
    }

    public String toString() {
        return String.format("x=%s\ny=%s\n", this.getAffineX().toString(), this.getAffineY().toString());
    }
}

