/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.crypto.ed25519;

import io.nem.core.crypto.Hashes;
import io.nem.core.crypto.PrivateKey;
import io.nem.core.crypto.ed25519.arithmetic.Ed25519EncodedFieldElement;
import java.util.Arrays;

public class Ed25519Utils {
    public static Ed25519EncodedFieldElement prepareForScalarMultiply(PrivateKey key) {
        byte[] hash = Hashes.sha3_512(new byte[][]{key.getBytes()});
        byte[] a = Arrays.copyOfRange(hash, 0, 32);
        a[31] = (byte)(a[31] & 0x7F);
        a[31] = (byte)(a[31] | 0x40);
        a[0] = (byte)(a[0] & 0xF8);
        return new Ed25519EncodedFieldElement(a);
    }
}

