/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.crypto.ed25519;

import io.nem.core.crypto.CryptoEngines;
import io.nem.core.crypto.KeyGenerator;
import io.nem.core.crypto.KeyPair;
import io.nem.core.crypto.PrivateKey;
import io.nem.core.crypto.PublicKey;
import io.nem.core.crypto.ed25519.Ed25519Utils;
import io.nem.core.crypto.ed25519.arithmetic.Ed25519EncodedFieldElement;
import io.nem.core.crypto.ed25519.arithmetic.Ed25519Group;
import io.nem.core.crypto.ed25519.arithmetic.Ed25519GroupElement;
import io.nem.core.utils.ArrayUtils;
import java.security.SecureRandom;

public class Ed25519KeyGenerator
implements KeyGenerator {
    private final SecureRandom random = new SecureRandom();

    @Override
    public KeyPair generateKeyPair() {
        byte[] seed = new byte[32];
        this.random.nextBytes(seed);
        PrivateKey privateKey = new PrivateKey(ArrayUtils.toBigInteger(seed));
        return new KeyPair(privateKey, CryptoEngines.ed25519Engine());
    }

    @Override
    public PublicKey derivePublicKey(PrivateKey privateKey) {
        Ed25519EncodedFieldElement a = Ed25519Utils.prepareForScalarMultiply(privateKey);
        Ed25519GroupElement pubKey = Ed25519Group.BASE_POINT.scalarMultiply(a);
        return new PublicKey(pubKey.encode().getRaw());
    }
}

