/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.crypto.ed25519;

import io.nem.core.crypto.BlockCipher;
import io.nem.core.crypto.Hashes;
import io.nem.core.crypto.KeyPair;
import io.nem.core.crypto.PrivateKey;
import io.nem.core.crypto.PublicKey;
import io.nem.core.crypto.ed25519.Ed25519Utils;
import io.nem.core.crypto.ed25519.arithmetic.Ed25519EncodedGroupElement;
import io.nem.core.crypto.ed25519.arithmetic.Ed25519GroupElement;
import java.security.SecureRandom;
import java.util.Arrays;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class Ed25519BlockCipher
implements BlockCipher {
    private final KeyPair senderKeyPair;
    private final KeyPair recipientKeyPair;
    private final SecureRandom random;
    private final int keyLength;

    public Ed25519BlockCipher(KeyPair senderKeyPair, KeyPair recipientKeyPair) {
        this.senderKeyPair = senderKeyPair;
        this.recipientKeyPair = recipientKeyPair;
        this.random = new SecureRandom();
        this.keyLength = recipientKeyPair.getPublicKey().getRaw().length;
    }

    @Override
    public byte[] encrypt(byte[] input) {
        byte[] salt = new byte[this.keyLength];
        this.random.nextBytes(salt);
        byte[] sharedKey = this.getSharedKey(this.senderKeyPair.getPrivateKey(), this.recipientKeyPair.getPublicKey(), salt);
        byte[] ivData = new byte[16];
        this.random.nextBytes(ivData);
        BufferedBlockCipher cipher = this.setupBlockCipher(sharedKey, ivData, true);
        byte[] buf = this.transform(cipher, input);
        if (null == buf) {
            return null;
        }
        byte[] result = new byte[salt.length + ivData.length + buf.length];
        System.arraycopy(salt, 0, result, 0, salt.length);
        System.arraycopy(ivData, 0, result, salt.length, ivData.length);
        System.arraycopy(buf, 0, result, salt.length + ivData.length, buf.length);
        return result;
    }

    @Override
    public byte[] decrypt(byte[] input) {
        if (input.length < 64) {
            return null;
        }
        byte[] salt = Arrays.copyOfRange(input, 0, this.keyLength);
        byte[] ivData = Arrays.copyOfRange(input, this.keyLength, 48);
        byte[] encData = Arrays.copyOfRange(input, 48, input.length);
        byte[] sharedKey = this.getSharedKey(this.recipientKeyPair.getPrivateKey(), this.senderKeyPair.getPublicKey(), salt);
        BufferedBlockCipher cipher = this.setupBlockCipher(sharedKey, ivData, false);
        return this.transform(cipher, encData);
    }

    private byte[] transform(BufferedBlockCipher cipher, byte[] data) {
        byte[] buf = new byte[cipher.getOutputSize(data.length)];
        int length = cipher.processBytes(data, 0, data.length, buf, 0);
        try {
            length += cipher.doFinal(buf, length);
        }
        catch (InvalidCipherTextException e) {
            return null;
        }
        return Arrays.copyOf(buf, length);
    }

    private BufferedBlockCipher setupBlockCipher(byte[] sharedKey, byte[] ivData, boolean forEncryption) {
        KeyParameter keyParam = new KeyParameter(sharedKey);
        ParametersWithIV params = new ParametersWithIV((CipherParameters)keyParam, ivData);
        PKCS7Padding padding = new PKCS7Padding();
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((org.bouncycastle.crypto.BlockCipher)new CBCBlockCipher((org.bouncycastle.crypto.BlockCipher)new AESEngine()), (BlockCipherPadding)padding);
        cipher.reset();
        cipher.init(forEncryption, (CipherParameters)params);
        return cipher;
    }

    private byte[] getSharedKey(PrivateKey privateKey, PublicKey publicKey, byte[] salt) {
        Ed25519GroupElement senderA = new Ed25519EncodedGroupElement(publicKey.getRaw()).decode();
        senderA.precomputeForScalarMultiplication();
        byte[] sharedKey = senderA.scalarMultiply(Ed25519Utils.prepareForScalarMultiply(privateKey)).encode().getRaw();
        for (int i = 0; i < this.keyLength; ++i) {
            int n = i;
            sharedKey[n] = (byte)(sharedKey[n] ^ salt[i]);
        }
        return Hashes.sha3_256(new byte[][]{sharedKey});
    }
}

