/*
 * Decompiled with CFR 0.152.
 */
package io.nem.core.crypto;

import io.nem.core.crypto.CryptoException;
import io.nem.core.utils.HexEncoder;
import java.math.BigInteger;

public class PrivateKey {
    private final BigInteger value;

    public PrivateKey(BigInteger value) {
        this.value = value;
    }

    public static PrivateKey fromHexString(String hex) {
        try {
            return new PrivateKey(new BigInteger(HexEncoder.getBytes(hex)));
        }
        catch (IllegalArgumentException e) {
            throw new CryptoException(e);
        }
    }

    public static PrivateKey fromDecimalString(String decimal) {
        try {
            return new PrivateKey(new BigInteger(decimal, 10));
        }
        catch (NumberFormatException e) {
            throw new CryptoException(e);
        }
    }

    public BigInteger getRaw() {
        return this.value;
    }

    public byte[] getBytes() {
        byte[] bytes = this.value.toByteArray();
        return bytes;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PrivateKey)) {
            return false;
        }
        PrivateKey rhs = (PrivateKey)obj;
        return this.value.equals(rhs.value);
    }

    public String toString() {
        return HexEncoder.getString(this.value.toByteArray());
    }
}

