/*
 * Copyright 2018 NEM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// automatically generated by the FlatBuffers compiler, do not modify

package io.nem.sdk.model.transaction;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@SuppressWarnings("unused")
final class MessageBuffer extends Table {
    public static MessageBuffer getRootAsMessageBuffer(ByteBuffer _bb) {
        return getRootAsMessageBuffer(_bb, new MessageBuffer());
    }

    public static MessageBuffer getRootAsMessageBuffer(ByteBuffer _bb, MessageBuffer obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return (obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb));
    }

    public static int createMessageBuffer(FlatBufferBuilder builder,
                                          int type,
                                          int payloadOffset) {
        builder.startObject(2);
        MessageBuffer.addPayload(builder, payloadOffset);
        MessageBuffer.addType(builder, type);
        return MessageBuffer.endMessageBuffer(builder);
    }

    public static void startMessageBuffer(FlatBufferBuilder builder) {
        builder.startObject(2);
    }

    public static void addType(FlatBufferBuilder builder, int type) {
        builder.addByte(0, (byte) type, (byte) 0);
    }

    public static void addPayload(FlatBufferBuilder builder, int payloadOffset) {
        builder.addOffset(1, payloadOffset, 0);
    }

    public static int createPayloadVector(FlatBufferBuilder builder, byte[] data) {
        builder.startVector(1, data.length, 1);
        for (int i = data.length - 1; i >= 0; i--) builder.addByte(data[i]);
        return builder.endVector();
    }

    public static void startPayloadVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(1, numElems, 1);
    }

    public static int endMessageBuffer(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }

    public void __init(int _i, ByteBuffer _bb) {
        bb_pos = _i;
        bb = _bb;
    }

    public MessageBuffer __assign(int _i, ByteBuffer _bb) {
        __init(_i, _bb);
        return this;
    }

    public int type() {
        int o = __offset(4);
        return o != 0 ? bb.get(o + bb_pos) & 0xFF : 0;
    }

    public int payload(int j) {
        int o = __offset(6);
        return o != 0 ? bb.get(__vector(o) + j * 1) & 0xFF : 0;
    }

    public int payloadLength() {
        int o = __offset(6);
        return o != 0 ? __vector_len(o) : 0;
    }

    public ByteBuffer payloadAsByteBuffer() {
        return __vector_as_bytebuffer(6, 1);
    }
}

