/*
 * Copyright 2018 NEM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * NIS2 API
 * This document defines all the nis2 api routes and behaviour
 *
 * OpenAPI spec version: 1.0.0
 * Contact: guillemchain@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.nem.sdk.infrastructure;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;

/**
 * NamespaceDTO
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-03-08T14:38:43.120Z")
public class NamespaceDTO {
    @SerializedName("type")
    private Integer type = null;

    @SerializedName("depth")
    private Integer depth = null;

    @SerializedName("level0")
    private UInt64DTO level0 = null;

    @SerializedName("level1")
    private UInt64DTO level1 = null;

    @SerializedName("level2")
    private UInt64DTO level2 = null;

    @SerializedName("parentId")
    private UInt64DTO parentId = null;

    @SerializedName("owner")
    private String owner = null;

    @SerializedName("ownerAddress")
    private String ownerAddress = null;

    @SerializedName("startHeight")
    private UInt64DTO startHeight = null;

    @SerializedName("endHeight")
    private UInt64DTO endHeight = null;

    public NamespaceDTO type(Integer type) {
        this.type = type;
        return this;
    }

    /**
     * Get type
     * @return type
     **/
    @ApiModelProperty(required = true, value = "")
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public NamespaceDTO depth(Integer depth) {
        this.depth = depth;
        return this;
    }

    /**
     * Get depth
     * @return depth
     **/
    @ApiModelProperty(required = true, value = "")
    public Integer getDepth() {
        return depth;
    }

    public void setDepth(Integer depth) {
        this.depth = depth;
    }

    public NamespaceDTO level0(UInt64DTO level0) {
        this.level0 = level0;
        return this;
    }

    /**
     * Get level0
     * @return level0
     **/
    @ApiModelProperty(required = true, value = "")
    public UInt64DTO getLevel0() {
        return level0;
    }

    public void setLevel0(UInt64DTO level0) {
        this.level0 = level0;
    }

    public NamespaceDTO level1(UInt64DTO level1) {
        this.level1 = level1;
        return this;
    }

    /**
     * Get level1
     * @return level1
     **/
    @ApiModelProperty(value = "")
    public UInt64DTO getLevel1() {
        return level1;
    }

    public void setLevel1(UInt64DTO level1) {
        this.level1 = level1;
    }

    public NamespaceDTO level2(UInt64DTO level2) {
        this.level2 = level2;
        return this;
    }

    /**
     * Get level2
     * @return level2
     **/
    @ApiModelProperty(value = "")
    public UInt64DTO getLevel2() {
        return level2;
    }

    public void setLevel2(UInt64DTO level2) {
        this.level2 = level2;
    }

    public NamespaceDTO parentId(UInt64DTO parentId) {
        this.parentId = parentId;
        return this;
    }

    /**
     * Get parentId
     * @return parentId
     **/
    @ApiModelProperty(required = true, value = "")
    public UInt64DTO getParentId() {
        return parentId;
    }

    public void setParentId(UInt64DTO parentId) {
        this.parentId = parentId;
    }

    public NamespaceDTO owner(String owner) {
        this.owner = owner;
        return this;
    }

    /**
     * Get owner
     * @return owner
     **/
    @ApiModelProperty(required = true, value = "")
    public String getOwner() {
        return owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public NamespaceDTO ownerAddress(String ownerAddress) {
        this.ownerAddress = ownerAddress;
        return this;
    }

    /**
     * Get ownerAddress
     * @return ownerAddress
     **/
    @ApiModelProperty(value = "")
    public String getOwnerAddress() {
        return ownerAddress;
    }

    public void setOwnerAddress(String ownerAddress) {
        this.ownerAddress = ownerAddress;
    }

    public NamespaceDTO startHeight(UInt64DTO startHeight) {
        this.startHeight = startHeight;
        return this;
    }

    /**
     * Get startHeight
     * @return startHeight
     **/
    @ApiModelProperty(required = true, value = "")
    public UInt64DTO getStartHeight() {
        return startHeight;
    }

    public void setStartHeight(UInt64DTO startHeight) {
        this.startHeight = startHeight;
    }

    public NamespaceDTO endHeight(UInt64DTO endHeight) {
        this.endHeight = endHeight;
        return this;
    }

    /**
     * Get endHeight
     * @return endHeight
     **/
    @ApiModelProperty(required = true, value = "")
    public UInt64DTO getEndHeight() {
        return endHeight;
    }

    public void setEndHeight(UInt64DTO endHeight) {
        this.endHeight = endHeight;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        NamespaceDTO namespaceDTO = (NamespaceDTO) o;
        return Objects.equals(this.type, namespaceDTO.type) &&
                Objects.equals(this.depth, namespaceDTO.depth) &&
                Objects.equals(this.level0, namespaceDTO.level0) &&
                Objects.equals(this.level1, namespaceDTO.level1) &&
                Objects.equals(this.level2, namespaceDTO.level2) &&
                Objects.equals(this.parentId, namespaceDTO.parentId) &&
                Objects.equals(this.owner, namespaceDTO.owner) &&
                Objects.equals(this.ownerAddress, namespaceDTO.ownerAddress) &&
                Objects.equals(this.startHeight, namespaceDTO.startHeight) &&
                Objects.equals(this.endHeight, namespaceDTO.endHeight);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, depth, level0, level1, level2, parentId, owner, ownerAddress, startHeight, endHeight);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NamespaceDTO {\n");

        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    depth: ").append(toIndentedString(depth)).append("\n");
        sb.append("    level0: ").append(toIndentedString(level0)).append("\n");
        sb.append("    level1: ").append(toIndentedString(level1)).append("\n");
        sb.append("    level2: ").append(toIndentedString(level2)).append("\n");
        sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
        sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
        sb.append("    ownerAddress: ").append(toIndentedString(ownerAddress)).append("\n");
        sb.append("    startHeight: ").append(toIndentedString(startHeight)).append("\n");
        sb.append("    endHeight: ").append(toIndentedString(endHeight)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}

