/*
 * Copyright 2018 NEM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.nem.core.crypto;

/**
 * Interface to analyze keys.
 */
public interface KeyAnalyzer {

    /**
     * Gets a value indicating whether or not the public key is compressed.
     *
     * @param publicKey The public key.
     * @return true if the public key is compressed, false otherwise.
     */
    boolean isKeyCompressed(final PublicKey publicKey);
}
