/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx.mappers;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.Mosaic;
import io.nem.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.sdk.model.transaction.HashLockTransaction;
import io.nem.sdk.model.transaction.HashLockTransactionFactory;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.TransactionFactory;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.vertx.model.HashLockTransactionDTO;
import java.math.BigInteger;

class HashLockTransactionMapper
extends AbstractTransactionMapper<HashLockTransactionDTO, HashLockTransaction> {
    public HashLockTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.LOCK, HashLockTransactionDTO.class);
    }

    private Mosaic getMosaic(HashLockTransactionDTO mosaic) {
        return new Mosaic((UnresolvedMosaicId)MapperUtils.toMosaicId((String)mosaic.getMosaicId()), mosaic.getAmount());
    }

    @Override
    protected TransactionFactory<HashLockTransaction> createFactory(NetworkType networkType, HashLockTransactionDTO transaction) {
        return HashLockTransactionFactory.create((NetworkType)networkType, (Mosaic)this.getMosaic(transaction), (BigInteger)transaction.getDuration(), (String)transaction.getHash());
    }

    @Override
    protected void copyToDto(HashLockTransaction transaction, HashLockTransactionDTO dto) {
        dto.setMosaicId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getMosaic().getId()));
        dto.setAmount(transaction.getMosaic().getAmount());
        dto.setDuration(transaction.getDuration());
        dto.setHash(transaction.getHash());
    }
}

