/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.model.account.Address;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.MosaicId;
import io.nem.sdk.model.receipt.AddressResolutionStatement;
import io.nem.sdk.model.receipt.ArtifactExpiryReceipt;
import io.nem.sdk.model.receipt.BalanceChangeReceipt;
import io.nem.sdk.model.receipt.BalanceTransferReceipt;
import io.nem.sdk.model.receipt.InflationReceipt;
import io.nem.sdk.model.receipt.MosaicResolutionStatement;
import io.nem.sdk.model.receipt.Receipt;
import io.nem.sdk.model.receipt.ReceiptSource;
import io.nem.sdk.model.receipt.ReceiptType;
import io.nem.sdk.model.receipt.ReceiptVersion;
import io.nem.sdk.model.receipt.ResolutionEntry;
import io.nem.sdk.model.receipt.Statement;
import io.nem.sdk.model.receipt.TransactionStatement;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.openapi.vertx.model.BalanceChangeReceiptDTO;
import io.nem.sdk.openapi.vertx.model.BalanceTransferReceiptDTO;
import io.nem.sdk.openapi.vertx.model.InflationReceiptDTO;
import io.nem.sdk.openapi.vertx.model.MosaicExpiryReceiptDTO;
import io.nem.sdk.openapi.vertx.model.NamespaceExpiryReceiptDTO;
import io.nem.sdk.openapi.vertx.model.ResolutionStatementBodyDTO;
import io.nem.sdk.openapi.vertx.model.ResolutionStatementDTO;
import io.nem.sdk.openapi.vertx.model.StatementsDTO;
import io.nem.sdk.openapi.vertx.model.TransactionStatementDTO;
import java.util.List;
import java.util.stream.Collectors;

public class ReceiptMappingVertx {
    private final JsonHelper jsonHelper;

    public ReceiptMappingVertx(JsonHelper jsonHelper) {
        this.jsonHelper = jsonHelper;
    }

    public Statement createStatementFromDto(StatementsDTO input, NetworkType networkType) {
        List transactionStatements = input.getTransactionStatements().stream().map(receiptDto -> this.createTransactionStatement((TransactionStatementDTO)receiptDto, networkType)).collect(Collectors.toList());
        List addressResolutionStatements = input.getAddressResolutionStatements().stream().map(this::createAddressResolutionStatementFromDto).collect(Collectors.toList());
        List mosaicResolutionStatements = input.getMosaicResolutionStatements().stream().map(this::createMosaicResolutionStatementFromDto).collect(Collectors.toList());
        return new Statement(transactionStatements, addressResolutionStatements, mosaicResolutionStatements);
    }

    public AddressResolutionStatement createAddressResolutionStatementFromDto(ResolutionStatementDTO receiptDto) {
        ResolutionStatementBodyDTO statement = receiptDto.getStatement();
        return new AddressResolutionStatement(statement.getHeight(), MapperUtils.toUnresolvedAddress((String)statement.getUnresolved().toString()), statement.getResolutionEntries().stream().map(entry -> ResolutionEntry.forAddress((Address)MapperUtils.toAddressFromEncoded((String)entry.getResolved().toString()), (ReceiptSource)new ReceiptSource(entry.getSource().getPrimaryId().intValue(), entry.getSource().getSecondaryId().intValue()))).collect(Collectors.toList()));
    }

    public MosaicResolutionStatement createMosaicResolutionStatementFromDto(ResolutionStatementDTO receiptDto) {
        ResolutionStatementBodyDTO statement = receiptDto.getStatement();
        return new MosaicResolutionStatement(statement.getHeight(), MapperUtils.toUnresolvedMosaicId((String)statement.getUnresolved().toString()), statement.getResolutionEntries().stream().map(entry -> ResolutionEntry.forMosaicId((MosaicId)MapperUtils.toMosaicId((String)entry.getResolved().toString()), (ReceiptSource)new ReceiptSource(entry.getSource().getPrimaryId().intValue(), entry.getSource().getSecondaryId().intValue()))).collect(Collectors.toList()));
    }

    public TransactionStatement createTransactionStatement(TransactionStatementDTO input, NetworkType networkType) {
        return new TransactionStatement(input.getStatement().getHeight(), new ReceiptSource(input.getStatement().getSource().getPrimaryId().intValue(), input.getStatement().getSource().getSecondaryId().intValue()), input.getStatement().getReceipts().stream().map(receipt -> this.createReceiptFromDto(receipt, networkType)).collect(Collectors.toList()));
    }

    public Receipt createReceiptFromDto(Object receiptDto, NetworkType networkType) {
        ReceiptType type = ReceiptType.rawValueOf((int)this.jsonHelper.getInteger(receiptDto, new String[]{"type"}));
        switch (type) {
            case HARVEST_FEE: 
            case LOCK_HASH_CREATED: 
            case LOCK_HASH_COMPLETED: 
            case LOCK_HASH_EXPIRED: 
            case LOCK_SECRET_CREATED: 
            case LOCK_SECRET_COMPLETED: 
            case LOCK_SECRET_EXPIRED: {
                return this.createBalanceChangeReceipt((BalanceChangeReceiptDTO)this.jsonHelper.convert(receiptDto, BalanceChangeReceiptDTO.class), networkType);
            }
            case MOSAIC_RENTAL_FEE: 
            case NAMESPACE_RENTAL_FEE: {
                return this.createBalanceTransferRecipient((BalanceTransferReceiptDTO)this.jsonHelper.convert(receiptDto, BalanceTransferReceiptDTO.class), networkType);
            }
            case MOSAIC_EXPIRED: {
                return this.createArtifactExpiryReceipt((MosaicExpiryReceiptDTO)this.jsonHelper.convert(receiptDto, MosaicExpiryReceiptDTO.class), type);
            }
            case NAMESPACE_EXPIRED: 
            case NAMESPACE_DELETED: {
                return this.createArtifactExpiryReceipt((NamespaceExpiryReceiptDTO)this.jsonHelper.convert(receiptDto, NamespaceExpiryReceiptDTO.class), type);
            }
            case INFLATION: {
                return this.createInflationReceipt((InflationReceiptDTO)this.jsonHelper.convert(receiptDto, InflationReceiptDTO.class));
            }
        }
        throw new IllegalArgumentException("Receipt type: " + type.name() + " not valid");
    }

    public ArtifactExpiryReceipt<MosaicId> createArtifactExpiryReceipt(NamespaceExpiryReceiptDTO receipt, ReceiptType type) {
        return new ArtifactExpiryReceipt((Object)MapperUtils.toMosaicId((String)receipt.getArtifactId()), type, ReceiptVersion.ARTIFACT_EXPIRY);
    }

    public ArtifactExpiryReceipt<MosaicId> createArtifactExpiryReceipt(MosaicExpiryReceiptDTO receipt, ReceiptType type) {
        return new ArtifactExpiryReceipt((Object)MapperUtils.toMosaicId((String)receipt.getArtifactId()), type, ReceiptVersion.ARTIFACT_EXPIRY);
    }

    public BalanceChangeReceipt createBalanceChangeReceipt(BalanceChangeReceiptDTO receipt, NetworkType networkType) {
        return new BalanceChangeReceipt(PublicAccount.createFromPublicKey((String)receipt.getTargetPublicKey(), (NetworkType)networkType), new MosaicId(receipt.getMosaicId()), receipt.getAmount(), ReceiptType.rawValueOf((int)receipt.getType().getValue()), ReceiptVersion.BALANCE_CHANGE);
    }

    public BalanceTransferReceipt createBalanceTransferRecipient(BalanceTransferReceiptDTO receipt, NetworkType networkType) {
        return new BalanceTransferReceipt(PublicAccount.createFromPublicKey((String)receipt.getSenderPublicKey(), (NetworkType)networkType), MapperUtils.toUnresolvedAddress((String)receipt.getRecipientAddress()), new MosaicId(receipt.getMosaicId()), receipt.getAmount(), ReceiptType.rawValueOf((int)receipt.getType().getValue()), ReceiptVersion.BALANCE_TRANSFER);
    }

    public InflationReceipt createInflationReceipt(InflationReceiptDTO receipt) {
        return new InflationReceipt(new MosaicId(receipt.getMosaicId()), receipt.getAmount(), ReceiptType.rawValueOf((int)receipt.getType().getValue()), ReceiptVersion.INFLATION_RECEIPT);
    }
}

