/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx.mappers;

import io.nem.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.AccountOperationRestrictionTransaction;
import io.nem.sdk.model.transaction.AccountOperationRestrictionTransactionFactory;
import io.nem.sdk.model.transaction.AccountRestrictionFlags;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.vertx.model.AccountOperationRestrictionTransactionDTO;
import io.nem.sdk.openapi.vertx.model.AccountRestrictionFlagsEnum;
import io.nem.sdk.openapi.vertx.model.TransactionTypeEnum;
import java.util.List;
import java.util.stream.Collectors;

public class AccountOperationRestrictionTransactionMapper
extends AbstractTransactionMapper<AccountOperationRestrictionTransactionDTO, AccountOperationRestrictionTransaction> {
    public AccountOperationRestrictionTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.ACCOUNT_OPERATION_RESTRICTION, AccountOperationRestrictionTransactionDTO.class);
    }

    protected AccountOperationRestrictionTransactionFactory createFactory(NetworkType networkType, AccountOperationRestrictionTransactionDTO transaction) {
        AccountRestrictionFlags restrictionFlags = AccountRestrictionFlags.rawValueOf((int)transaction.getRestrictionFlags().getValue());
        List additions = transaction.getRestrictionAdditions().stream().map((? super T transactionTypeEnum) -> TransactionType.rawValueOf((int)transactionTypeEnum.getValue())).collect(Collectors.toList());
        List deletions = transaction.getRestrictionDeletions().stream().map((? super T transactionTypeEnum) -> TransactionType.rawValueOf((int)transactionTypeEnum.getValue())).collect(Collectors.toList());
        return AccountOperationRestrictionTransactionFactory.create((NetworkType)networkType, (AccountRestrictionFlags)restrictionFlags, additions, deletions);
    }

    @Override
    protected void copyToDto(AccountOperationRestrictionTransaction transaction, AccountOperationRestrictionTransactionDTO dto) {
        dto.setRestrictionFlags(AccountRestrictionFlagsEnum.fromValue((Integer)transaction.getRestrictionFlags().getValue()));
        List additions = transaction.getRestrictionAdditions().stream().map((? super T transactionType) -> TransactionTypeEnum.fromValue((Integer)transactionType.getValue())).collect(Collectors.toList());
        List deletions = transaction.getRestrictionDeletions().stream().map((? super T transactionType) -> TransactionTypeEnum.fromValue((Integer)transactionType.getValue())).collect(Collectors.toList());
        dto.setRestrictionAdditions(additions);
        dto.setRestrictionDeletions(deletions);
    }
}

