/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx.mappers;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.AccountAddressRestrictionTransaction;
import io.nem.sdk.model.transaction.AccountAddressRestrictionTransactionFactory;
import io.nem.sdk.model.transaction.AccountRestrictionFlags;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.vertx.model.AccountAddressRestrictionTransactionDTO;
import io.nem.sdk.openapi.vertx.model.AccountRestrictionFlagsEnum;
import java.util.List;
import java.util.stream.Collectors;

public class AccountAddressRestrictionTransactionMapper
extends AbstractTransactionMapper<AccountAddressRestrictionTransactionDTO, AccountAddressRestrictionTransaction> {
    public AccountAddressRestrictionTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.ACCOUNT_ADDRESS_RESTRICTION, AccountAddressRestrictionTransactionDTO.class);
    }

    protected AccountAddressRestrictionTransactionFactory createFactory(NetworkType networkType, AccountAddressRestrictionTransactionDTO transaction) {
        AccountRestrictionFlags restrictionFlags = AccountRestrictionFlags.rawValueOf((int)transaction.getRestrictionFlags().getValue());
        List restrictionAdditions = transaction.getRestrictionAdditions().stream().map(MapperUtils::toUnresolvedAddress).collect(Collectors.toList());
        List restrictionDeletions = transaction.getRestrictionDeletions().stream().map(MapperUtils::toUnresolvedAddress).collect(Collectors.toList());
        return AccountAddressRestrictionTransactionFactory.create((NetworkType)networkType, (AccountRestrictionFlags)restrictionFlags, restrictionAdditions, restrictionDeletions);
    }

    @Override
    protected void copyToDto(AccountAddressRestrictionTransaction transaction, AccountAddressRestrictionTransactionDTO dto) {
        dto.setRestrictionFlags(AccountRestrictionFlagsEnum.fromValue((Integer)transaction.getRestrictionFlags().getValue()));
        dto.setRestrictionAdditions(transaction.getRestrictionAdditions().stream().map((? super T r) -> r.encoded(transaction.getNetworkType())).collect(Collectors.toList()));
        dto.setRestrictionDeletions(transaction.getRestrictionDeletions().stream().map((? super T r) -> r.encoded(transaction.getNetworkType())).collect(Collectors.toList()));
    }
}

