/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.api.RestrictionMosaicRepository;
import io.nem.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.sdk.model.account.Address;
import io.nem.sdk.model.mosaic.MosaicId;
import io.nem.sdk.model.restriction.MosaicAddressRestriction;
import io.nem.sdk.model.restriction.MosaicGlobalRestriction;
import io.nem.sdk.model.restriction.MosaicGlobalRestrictionItem;
import io.nem.sdk.model.restriction.MosaicRestrictionEntryType;
import io.nem.sdk.model.transaction.MosaicRestrictionType;
import io.nem.sdk.openapi.vertx.api.RestrictionMosaicRoutesApi;
import io.nem.sdk.openapi.vertx.api.RestrictionMosaicRoutesApiImpl;
import io.nem.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.sdk.openapi.vertx.model.AccountIds;
import io.nem.sdk.openapi.vertx.model.MosaicAddressRestrictionDTO;
import io.nem.sdk.openapi.vertx.model.MosaicAddressRestrictionEntryWrapperDTO;
import io.nem.sdk.openapi.vertx.model.MosaicGlobalRestrictionDTO;
import io.nem.sdk.openapi.vertx.model.MosaicGlobalRestrictionEntryRestrictionDTO;
import io.nem.sdk.openapi.vertx.model.MosaicGlobalRestrictionEntryWrapperDTO;
import io.nem.sdk.openapi.vertx.model.MosaicIds;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RestrictionMosaicRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements RestrictionMosaicRepository {
    private final RestrictionMosaicRoutesApi client;

    public RestrictionMosaicRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new RestrictionMosaicRoutesApiImpl(apiClient);
    }

    public Observable<MosaicAddressRestriction> getMosaicAddressRestriction(MosaicId mosaicId, Address address) {
        return this.exceptionHandling(this.call(handler -> this.getClient().getMosaicAddressRestriction(mosaicId.getIdAsHex(), address.plain(), handler)).map(this::toMosaicAddressRestriction));
    }

    public Observable<List<MosaicAddressRestriction>> getMosaicAddressRestrictions(MosaicId mosaicId, List<Address> addresses) {
        AccountIds accountIds = new AccountIds().addresses(addresses.stream().map(Address::plain).collect(Collectors.toList()));
        return this.exceptionHandling(this.call(handler -> this.getClient().getMosaicAddressRestrictions(mosaicId.getIdAsHex(), accountIds, handler)).flatMapIterable(item -> item).map(this::toMosaicAddressRestriction)).toList().toObservable();
    }

    public Observable<MosaicGlobalRestriction> getMosaicGlobalRestriction(MosaicId mosaicId) {
        return this.exceptionHandling(this.call(handler -> this.getClient().getMosaicGlobalRestriction(mosaicId.getIdAsHex(), handler)).map(this::toMosaicGlobalRestriction));
    }

    public Observable<List<MosaicGlobalRestriction>> getMosaicGlobalRestrictions(List<MosaicId> mosaicIds) {
        MosaicIds mosaicIdsParmas = new MosaicIds().mosaicIds(mosaicIds.stream().map(MosaicId::getIdAsHex).collect(Collectors.toList()));
        return this.exceptionHandling(this.call(handler -> this.getClient().getMosaicGlobalRestrictions(mosaicIdsParmas, handler)).flatMapIterable(item -> item).map(this::toMosaicGlobalRestriction)).toList().toObservable();
    }

    private MosaicGlobalRestriction toMosaicGlobalRestriction(MosaicGlobalRestrictionDTO mosaicGlobalRestrictionDTO) {
        MosaicGlobalRestrictionEntryWrapperDTO dto = mosaicGlobalRestrictionDTO.getMosaicRestrictionEntry();
        Map<BigInteger, MosaicGlobalRestrictionItem> restrictions = dto.getRestrictions().stream().collect(Collectors.toMap(e -> new BigInteger(e.getKey()), e -> this.toMosaicGlobalRestrictionItem(e.getRestriction())));
        return new MosaicGlobalRestriction(dto.getCompositeHash(), MosaicRestrictionEntryType.rawValueOf((int)dto.getEntryType().getValue()), MapperUtils.toMosaicId((String)dto.getMosaicId()), restrictions);
    }

    private MosaicGlobalRestrictionItem toMosaicGlobalRestrictionItem(MosaicGlobalRestrictionEntryRestrictionDTO dto) {
        return new MosaicGlobalRestrictionItem(MapperUtils.toMosaicId((String)dto.getReferenceMosaicId()), dto.getRestrictionValue(), MosaicRestrictionType.rawValueOf((byte)dto.getRestrictionType().getValue().byteValue()));
    }

    private MosaicAddressRestriction toMosaicAddressRestriction(MosaicAddressRestrictionDTO mosaicAddressRestrictionDTO) {
        MosaicAddressRestrictionEntryWrapperDTO dto = mosaicAddressRestrictionDTO.getMosaicRestrictionEntry();
        Map<BigInteger, BigInteger> restrictions = dto.getRestrictions().stream().collect(Collectors.toMap(e -> new BigInteger(e.getKey()), e -> this.toBigInteger(e.getValue())));
        return new MosaicAddressRestriction(dto.getCompositeHash(), MosaicRestrictionEntryType.rawValueOf((int)dto.getEntryType().getValue()), MapperUtils.toMosaicId((String)dto.getMosaicId()), MapperUtils.toAddressFromEncoded((String)dto.getTargetAddress()), restrictions);
    }

    private BigInteger toBigInteger(String value) {
        return new BigInteger(value);
    }

    public RestrictionMosaicRoutesApi getClient() {
        return this.client;
    }
}

