/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx;

import io.nem.sdk.api.AccountRepository;
import io.nem.sdk.api.BlockRepository;
import io.nem.sdk.api.ChainRepository;
import io.nem.sdk.api.DiagnosticRepository;
import io.nem.sdk.api.JsonSerialization;
import io.nem.sdk.api.Listener;
import io.nem.sdk.api.MetadataRepository;
import io.nem.sdk.api.MosaicRepository;
import io.nem.sdk.api.MultisigRepository;
import io.nem.sdk.api.NamespaceRepository;
import io.nem.sdk.api.NetworkRepository;
import io.nem.sdk.api.NodeRepository;
import io.nem.sdk.api.ReceiptRepository;
import io.nem.sdk.api.RepositoryFactory;
import io.nem.sdk.api.RestrictionAccountRepository;
import io.nem.sdk.api.RestrictionMosaicRepository;
import io.nem.sdk.api.TransactionRepository;
import io.nem.sdk.infrastructure.vertx.AccountRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.BlockRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.ChainRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.DiagnosticRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.JsonHelperJackson2;
import io.nem.sdk.infrastructure.vertx.JsonSerializationVertx;
import io.nem.sdk.infrastructure.vertx.ListenerVertx;
import io.nem.sdk.infrastructure.vertx.MetadataRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.MosaicRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.MultisigRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.NamespaceRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.NetworkRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.NodeRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.ReceiptRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.RestrictionAccountRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.RestrictionMosaicRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.TransactionRepositoryVertxImpl;
import io.nem.sdk.model.blockchain.BlockInfo;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.openapi.vertx.invoker.ApiClient;
import io.reactivex.Observable;
import io.vertx.core.Vertx;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.WebClient;
import java.math.BigInteger;

public class RepositoryFactoryVertxImpl
implements RepositoryFactory {
    private final ApiClient apiClient;
    private final WebClient webClient;
    private final String baseUrl;
    private final Vertx vertx;
    private final Observable<NetworkType> networkTypeObservable;
    private final Observable<String> generationHashObservable;

    public RepositoryFactoryVertxImpl(String baseUrl) {
        this.baseUrl = baseUrl;
        this.vertx = Vertx.vertx();
        this.webClient = WebClient.create((Vertx)this.vertx);
        this.apiClient = new ApiClient(this.vertx, new JsonObject().put("basePath", baseUrl)){

            public synchronized WebClient getWebClient() {
                return RepositoryFactoryVertxImpl.this.webClient;
            }
        };
        JsonHelperJackson2.configureMapper(this.apiClient.getObjectMapper());
        JsonHelperJackson2.configureMapper(Json.mapper);
        this.networkTypeObservable = this.createNetworkRepository().getNetworkType().cache();
        this.generationHashObservable = this.createBlockRepository().getBlockByHeight(BigInteger.ONE).map(BlockInfo::getGenerationHash).cache();
    }

    public Observable<NetworkType> getNetworkType() {
        return this.networkTypeObservable;
    }

    public Observable<String> getGenerationHash() {
        return this.generationHashObservable;
    }

    public AccountRepository createAccountRepository() {
        return new AccountRepositoryVertxImpl(this.apiClient);
    }

    public MultisigRepository createMultisigRepository() {
        return new MultisigRepositoryVertxImpl(this.apiClient, this.networkTypeObservable);
    }

    public BlockRepository createBlockRepository() {
        return new BlockRepositoryVertxImpl(this.apiClient);
    }

    public ReceiptRepository createReceiptRepository() {
        return new ReceiptRepositoryVertxImpl(this.apiClient, this.networkTypeObservable);
    }

    public ChainRepository createChainRepository() {
        return new ChainRepositoryVertxImpl(this.apiClient);
    }

    public DiagnosticRepository createDiagnosticRepository() {
        return new DiagnosticRepositoryVertxImpl(this.apiClient);
    }

    public MosaicRepository createMosaicRepository() {
        return new MosaicRepositoryVertxImpl(this.apiClient, this.networkTypeObservable);
    }

    public NamespaceRepository createNamespaceRepository() {
        return new NamespaceRepositoryVertxImpl(this.apiClient, this.networkTypeObservable);
    }

    public NetworkRepository createNetworkRepository() {
        return new NetworkRepositoryVertxImpl(this.apiClient);
    }

    public NodeRepository createNodeRepository() {
        return new NodeRepositoryVertxImpl(this.apiClient);
    }

    public TransactionRepository createTransactionRepository() {
        return new TransactionRepositoryVertxImpl(this.apiClient);
    }

    public MetadataRepository createMetadataRepository() {
        return new MetadataRepositoryVertxImpl(this.apiClient);
    }

    public RestrictionAccountRepository createRestrictionAccountRepository() {
        return new RestrictionAccountRepositoryVertxImpl(this.apiClient);
    }

    public RestrictionMosaicRepository createRestrictionMosaicRepository() {
        return new RestrictionMosaicRepositoryVertxImpl(this.apiClient);
    }

    public Listener createListener() {
        return new ListenerVertx(this.vertx.createHttpClient(), this.baseUrl);
    }

    public JsonSerialization createJsonSerialization() {
        return new JsonSerializationVertx(this.apiClient.getObjectMapper());
    }

    public void close() {
        this.vertx.close();
        try {
            this.webClient.close();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

