/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx;

import io.nem.sdk.api.ReceiptRepository;
import io.nem.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.ReceiptMappingVertx;
import io.nem.sdk.model.blockchain.MerkelPathItem;
import io.nem.sdk.model.blockchain.MerkelProofInfo;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.receipt.Statement;
import io.nem.sdk.openapi.vertx.api.ReceiptRoutesApi;
import io.nem.sdk.openapi.vertx.api.ReceiptRoutesApiImpl;
import io.nem.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.sdk.openapi.vertx.model.MerkleProofInfoDTO;
import io.nem.sdk.openapi.vertx.model.StatementsDTO;
import io.reactivex.Observable;
import io.vertx.core.Handler;
import java.math.BigInteger;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ReceiptRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements ReceiptRepository {
    private final ReceiptRoutesApi client;
    private final Observable<NetworkType> networkTypeObservable;

    public ReceiptRepositoryVertxImpl(ApiClient apiClient, Observable<NetworkType> networkTypeObservable) {
        super(apiClient);
        this.client = new ReceiptRoutesApiImpl(apiClient);
        this.networkTypeObservable = networkTypeObservable;
    }

    public Observable<Statement> getBlockReceipts(BigInteger height) {
        Consumer<Handler> callback = handler -> this.getClient().getBlockReceipts(height, handler);
        return this.exceptionHandling(this.networkTypeObservable.flatMap(networkType -> this.call(callback).map(statementsDTO -> new ReceiptMappingVertx(this.getJsonHelper()).createStatementFromDto((StatementsDTO)statementsDTO, (NetworkType)networkType))));
    }

    public Observable<MerkelProofInfo> getMerkleReceipts(BigInteger height, String hash) {
        Consumer callback = handler -> this.getClient().getMerkleReceipts(height, hash, handler);
        return this.exceptionHandling(this.call(callback).map(this::toMerkelProofInfo));
    }

    private MerkelProofInfo toMerkelProofInfo(MerkleProofInfoDTO dto) {
        List pathItems = dto.getMerklePath().stream().map(pathItem -> new MerkelPathItem(pathItem.getPosition(), pathItem.getHash())).collect(Collectors.toList());
        return new MerkelProofInfo(pathItems);
    }

    public ReceiptRoutesApi getClient() {
        return this.client;
    }
}

