/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx;

import io.nem.sdk.api.NodeRepository;
import io.nem.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.node.NodeInfo;
import io.nem.sdk.model.node.NodeTime;
import io.nem.sdk.model.node.RoleType;
import io.nem.sdk.openapi.vertx.api.NodeRoutesApi;
import io.nem.sdk.openapi.vertx.api.NodeRoutesApiImpl;
import io.nem.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.sdk.openapi.vertx.model.NodeInfoDTO;
import io.nem.sdk.openapi.vertx.model.NodeTimeDTO;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.util.function.Consumer;

public class NodeRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements NodeRepository {
    private final NodeRoutesApi client;

    public NodeRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new NodeRoutesApiImpl(apiClient);
    }

    public NodeRoutesApi getClient() {
        return this.client;
    }

    public Observable<NodeInfo> getNodeInfo() {
        Consumer callback = handler -> this.getClient().getNodeInfo(handler);
        return this.exceptionHandling(this.call(callback).map(this::toNodeInfo));
    }

    private NodeInfo toNodeInfo(NodeInfoDTO nodeInfoDTO) {
        return new NodeInfo(nodeInfoDTO.getPublicKey(), nodeInfoDTO.getPort().intValue(), NetworkType.rawValueOf((int)nodeInfoDTO.getNetworkIdentifier()), nodeInfoDTO.getVersion().intValue(), RoleType.rawValueOf((int)nodeInfoDTO.getRoles().getValue()), nodeInfoDTO.getHost(), nodeInfoDTO.getFriendlyName());
    }

    public Observable<NodeTime> getNodeTime() {
        Consumer callback = handler -> this.getClient().getNodeTime(handler);
        return this.exceptionHandling(this.call(callback).map(this::toNodeTime));
    }

    private NodeTime toNodeTime(NodeTimeDTO nodeTimeDTO) {
        BigInteger sendTimestamp = nodeTimeDTO.getCommunicationTimestamps().getSendTimestamp();
        BigInteger receiveTimestamp = nodeTimeDTO.getCommunicationTimestamps().getReceiveTimestamp();
        return new NodeTime(sendTimestamp, receiveTimestamp);
    }
}

