/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.nem.sdk.api.Listener;
import io.nem.sdk.infrastructure.ListenerBase;
import io.nem.sdk.infrastructure.ListenerSubscribeMessage;
import io.nem.sdk.infrastructure.vertx.BlockRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.JsonHelperJackson2;
import io.nem.sdk.infrastructure.vertx.mappers.GeneralTransactionMapper;
import io.nem.sdk.infrastructure.vertx.mappers.TransactionMapper;
import io.nem.sdk.model.blockchain.BlockInfo;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.openapi.vertx.model.BlockInfoDTO;
import io.nem.sdk.openapi.vertx.model.TransactionInfoDTO;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.json.Json;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ListenerVertx
extends ListenerBase
implements Listener {
    private final URL url;
    private final HttpClient httpClient;
    private final TransactionMapper transactionMapper;
    private WebSocket webSocket;

    public ListenerVertx(HttpClient httpClient, String url) {
        super((JsonHelper)new JsonHelperJackson2(JsonHelperJackson2.configureMapper(Json.mapper)));
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Parameter '" + url + "' is not a valid URL. " + ExceptionUtils.getMessage((Throwable)e));
        }
        this.httpClient = httpClient;
        this.transactionMapper = new GeneralTransactionMapper(this.getJsonHelper());
    }

    public CompletableFuture<Void> open() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.webSocket != null) {
            return CompletableFuture.completedFuture(null);
        }
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setHost(this.url.getHost());
        requestOptions.setPort(this.url.getPort());
        requestOptions.setURI("/ws");
        this.httpClient.websocket(requestOptions, ws -> {
            this.webSocket = ws;
            ws.handler(handler -> {
                ObjectNode message = (ObjectNode)this.getJsonHelper().convert((Object)handler.toJsonObject(), ObjectNode.class);
                this.handle(message, future);
            });
        });
        return future;
    }

    protected BlockInfo toBlockInfo(Object blockInfoDTO) {
        return BlockRepositoryVertxImpl.toBlockInfo((BlockInfoDTO)this.getJsonHelper().convert(blockInfoDTO, BlockInfoDTO.class));
    }

    protected Transaction toTransaction(Object transactionInfo) {
        return this.transactionMapper.map((TransactionInfoDTO)this.getJsonHelper().convert(transactionInfo, TransactionInfoDTO.class));
    }

    public void close() {
        if (this.webSocket != null) {
            this.setUid(null);
            this.webSocket.close();
            this.webSocket = null;
        }
    }

    protected void subscribeTo(String channel) {
        ListenerSubscribeMessage subscribeMessage = new ListenerSubscribeMessage(this.getUid(), channel);
        this.webSocket.writeTextMessage(this.getJsonHelper().print((Object)subscribeMessage));
    }
}

