/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx;

import io.nem.sdk.api.DiagnosticRepository;
import io.nem.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.sdk.model.blockchain.BlockchainStorageInfo;
import io.nem.sdk.model.blockchain.ServerInfo;
import io.nem.sdk.openapi.vertx.api.DiagnosticRoutesApi;
import io.nem.sdk.openapi.vertx.api.DiagnosticRoutesApiImpl;
import io.nem.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.sdk.openapi.vertx.model.ServerDTO;
import io.nem.sdk.openapi.vertx.model.ServerInfoDTO;
import io.nem.sdk.openapi.vertx.model.StorageInfoDTO;
import io.reactivex.Observable;
import java.util.function.Consumer;

public class DiagnosticRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements DiagnosticRepository {
    private final DiagnosticRoutesApi client;

    public DiagnosticRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new DiagnosticRoutesApiImpl(apiClient);
    }

    public DiagnosticRoutesApi getClient() {
        return this.client;
    }

    public Observable<BlockchainStorageInfo> getBlockchainStorage() {
        Consumer callback = arg_0 -> ((DiagnosticRoutesApi)this.getClient()).getDiagnosticStorage(arg_0);
        return this.exceptionHandling(this.call(callback).map(this::toBlockchainStorageInfo));
    }

    private BlockchainStorageInfo toBlockchainStorageInfo(StorageInfoDTO blockchainStorageInfoDTO) {
        return new BlockchainStorageInfo(blockchainStorageInfoDTO.getNumAccounts(), blockchainStorageInfoDTO.getNumBlocks(), blockchainStorageInfoDTO.getNumTransactions());
    }

    public Observable<ServerInfo> getServerInfo() {
        Consumer callback = arg_0 -> ((DiagnosticRoutesApi)this.getClient()).getServerInfo(arg_0);
        return this.exceptionHandling(this.call(callback).map(ServerInfoDTO::getServerInfo).map(this::toServerInfo));
    }

    private ServerInfo toServerInfo(ServerDTO serverInfoDTO) {
        return new ServerInfo(serverInfoDTO.getRestVersion(), serverInfoDTO.getSdkVersion());
    }
}

