/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx;

import io.nem.sdk.api.QueryParams;
import io.nem.sdk.api.RepositoryCallException;
import io.nem.sdk.infrastructure.vertx.JsonHelperJackson2;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.sdk.openapi.vertx.invoker.ApiException;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.reactivex.core.impl.AsyncResultSingle;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class AbstractRepositoryVertxImpl {
    private final Supplier<NetworkType> networkType;
    private final JsonHelper jsonHelper;

    public AbstractRepositoryVertxImpl(ApiClient apiClient, Supplier<NetworkType> networkType) {
        this.networkType = networkType;
        this.jsonHelper = new JsonHelperJackson2(apiClient.getObjectMapper());
    }

    public <T> Observable<T> call(Consumer<Handler<AsyncResult<T>>> callback) {
        Function resumeFunction = this::onError;
        return new AsyncResultSingle(callback::accept).toObservable().onErrorResumeNext(resumeFunction);
    }

    public RepositoryCallException exceptionHandling(Throwable e) {
        if (e instanceof RepositoryCallException) {
            return (RepositoryCallException)e;
        }
        return new RepositoryCallException(this.extractMessageFromException(e), e);
    }

    private String extractMessageFromException(Throwable e) {
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(ExceptionUtils.getMessage((Throwable)e));
        if (e instanceof ApiException) {
            messages.add("" + ((ApiException)e).getCode());
            String responseBody = ((ApiException)e).getResponseBody();
            if (responseBody != null) {
                try {
                    Object json = this.jsonHelper.parse(responseBody);
                    messages.add(this.jsonHelper.getString(json, new String[]{"code"}));
                    messages.add(this.jsonHelper.getString(json, new String[]{"message"}));
                }
                catch (IllegalArgumentException ignore) {
                    messages.add(StringUtils.truncate((String)responseBody, (int)100));
                }
            }
        }
        return messages.stream().filter(StringUtils::isNotBlank).collect(Collectors.joining(" - "));
    }

    public <T> Observable<T> onError(Throwable e) {
        return Observable.error((Throwable)this.exceptionHandling(e));
    }

    protected NetworkType getNetworkTypeBlocking() {
        return this.networkType.get();
    }

    public <T> Observable<T> exceptionHandling(Observable<T> observable) {
        Function resumeFunction = this::onError;
        return observable.onErrorResumeNext(resumeFunction);
    }

    protected Integer getPageSize(Optional<QueryParams> queryParams) {
        return queryParams.map(QueryParams::getPageSize).orElse(null);
    }

    protected String getId(Optional<QueryParams> queryParams) {
        return queryParams.map(QueryParams::getId).orElse(null);
    }

    protected String getOrder(Optional<QueryParams> queryParams) {
        return queryParams.map(QueryParams::getOrder).orElse(null);
    }

    public JsonHelper getJsonHelper() {
        return this.jsonHelper;
    }
}

