/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx.mappers;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.sdk.model.account.UnresolvedAddress;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.Mosaic;
import io.nem.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.LockHashAlgorithmType;
import io.nem.sdk.model.transaction.SecretLockTransaction;
import io.nem.sdk.model.transaction.SecretLockTransactionFactory;
import io.nem.sdk.model.transaction.TransactionFactory;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.vertx.model.LockHashAlgorithmEnum;
import io.nem.sdk.openapi.vertx.model.SecretLockTransactionDTO;
import java.math.BigInteger;

class SecretLockTransactionMapper
extends AbstractTransactionMapper<SecretLockTransactionDTO, SecretLockTransaction> {
    public SecretLockTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.SECRET_LOCK, SecretLockTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<SecretLockTransaction> createFactory(NetworkType networkType, SecretLockTransactionDTO transaction) {
        Mosaic mosaic = new Mosaic((UnresolvedMosaicId)MapperUtils.toMosaicId((String)transaction.getMosaicId()), transaction.getAmount());
        return SecretLockTransactionFactory.create((NetworkType)networkType, (Mosaic)mosaic, (BigInteger)transaction.getDuration(), (LockHashAlgorithmType)LockHashAlgorithmType.rawValueOf((int)transaction.getHashAlgorithm().getValue()), (String)transaction.getSecret(), (UnresolvedAddress)MapperUtils.toUnresolvedAddress((String)transaction.getRecipientAddress()));
    }

    @Override
    protected void copyToDto(SecretLockTransaction transaction, SecretLockTransactionDTO dto) {
        dto.setAmount(transaction.getMosaic().getAmount());
        dto.setMosaicId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getMosaic().getId()));
        dto.setDuration(transaction.getDuration());
        dto.setHashAlgorithm(LockHashAlgorithmEnum.fromValue((Integer)transaction.getHashAlgorithm().getValue()));
        dto.setSecret(transaction.getSecret());
        dto.setRecipientAddress(transaction.getRecipient().encoded(transaction.getNetworkType()));
    }
}

