/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx.mappers;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.MosaicGlobalRestrictionTransaction;
import io.nem.sdk.model.transaction.MosaicGlobalRestrictionTransactionFactory;
import io.nem.sdk.model.transaction.MosaicRestrictionType;
import io.nem.sdk.model.transaction.TransactionFactory;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.vertx.model.MosaicGlobalRestrictionTransactionDTO;
import io.nem.sdk.openapi.vertx.model.MosaicRestrictionTypeEnum;
import java.math.BigInteger;

class MosaicGlobalRestrictionTransactionMapper
extends AbstractTransactionMapper<MosaicGlobalRestrictionTransactionDTO, MosaicGlobalRestrictionTransaction> {
    public MosaicGlobalRestrictionTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.MOSAIC_GLOBAL_RESTRICTION, MosaicGlobalRestrictionTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<MosaicGlobalRestrictionTransaction> createFactory(NetworkType networkType, MosaicGlobalRestrictionTransactionDTO transaction) {
        byte prevRestrictionType = transaction.getPreviousRestrictionType().getValue().byteValue();
        byte newRestrictionType = transaction.getNewRestrictionType().getValue().byteValue();
        return MosaicGlobalRestrictionTransactionFactory.create((NetworkType)networkType, (UnresolvedMosaicId)MapperUtils.toMosaicId((String)transaction.getMosaicId()), (BigInteger)MapperUtils.fromHexToBigInteger((String)transaction.getRestrictionKey()), (BigInteger)transaction.getNewRestrictionValue(), (MosaicRestrictionType)MosaicRestrictionType.rawValueOf((byte)newRestrictionType)).referenceMosaicId((UnresolvedMosaicId)MapperUtils.toMosaicId((String)transaction.getReferenceMosaicId())).previousRestrictionValue(transaction.getPreviousRestrictionValue()).previousRestrictionType(MosaicRestrictionType.rawValueOf((byte)prevRestrictionType));
    }

    @Override
    protected void copyToDto(MosaicGlobalRestrictionTransaction transaction, MosaicGlobalRestrictionTransactionDTO dto) {
        dto.setMosaicId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getMosaicId()));
        dto.setRestrictionKey(transaction.getRestrictionKey().toString(16));
        dto.setNewRestrictionValue(transaction.getNewRestrictionValue());
        dto.setPreviousRestrictionValue(transaction.getPreviousRestrictionValue());
        dto.setPreviousRestrictionType(MosaicRestrictionTypeEnum.fromValue((Integer)Integer.valueOf(transaction.getPreviousRestrictionType().getValue())));
        dto.setNewRestrictionType(MosaicRestrictionTypeEnum.fromValue((Integer)Integer.valueOf(transaction.getNewRestrictionType().getValue())));
        dto.setReferenceMosaicId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getReferenceMosaicId()));
    }
}

