/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx;

import io.nem.sdk.api.NetworkRepository;
import io.nem.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.openapi.vertx.api.NodeRoutesApi;
import io.nem.sdk.openapi.vertx.api.NodeRoutesApiImpl;
import io.nem.sdk.openapi.vertx.invoker.ApiClient;
import io.reactivex.Observable;
import java.util.function.Consumer;

public class NetworkRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements NetworkRepository {
    private final NodeRoutesApi client;

    public NetworkRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient, () -> {
            throw new IllegalStateException("This service is in charge of loading the network type");
        });
        this.client = new NodeRoutesApiImpl(apiClient);
    }

    public Observable<NetworkType> getNetworkType() {
        Consumer callback = handler -> this.getClient().getNodeInfo(handler);
        return this.exceptionHandling(this.call(callback).map(info -> NetworkType.rawValueOf((int)info.getNetworkIdentifier())));
    }

    public NodeRoutesApi getClient() {
        return this.client;
    }
}

