/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.api.NamespaceRepository;
import io.nem.sdk.api.QueryParams;
import io.nem.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.sdk.model.account.Address;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.MosaicId;
import io.nem.sdk.model.namespace.AddressAlias;
import io.nem.sdk.model.namespace.Alias;
import io.nem.sdk.model.namespace.AliasType;
import io.nem.sdk.model.namespace.EmptyAlias;
import io.nem.sdk.model.namespace.MosaicAlias;
import io.nem.sdk.model.namespace.NamespaceId;
import io.nem.sdk.model.namespace.NamespaceInfo;
import io.nem.sdk.model.namespace.NamespaceName;
import io.nem.sdk.model.namespace.NamespaceRegistrationType;
import io.nem.sdk.openapi.vertx.api.NamespaceRoutesApi;
import io.nem.sdk.openapi.vertx.api.NamespaceRoutesApiImpl;
import io.nem.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.sdk.openapi.vertx.model.AccountIds;
import io.nem.sdk.openapi.vertx.model.NamespaceDTO;
import io.nem.sdk.openapi.vertx.model.NamespaceIds;
import io.nem.sdk.openapi.vertx.model.NamespaceInfoDTO;
import io.nem.sdk.openapi.vertx.model.NamespaceNameDTO;
import io.reactivex.Observable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class NamespaceRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements NamespaceRepository {
    private final NamespaceRoutesApi client;

    public NamespaceRepositoryVertxImpl(ApiClient apiClient, Supplier<NetworkType> networkType) {
        super(apiClient, networkType);
        this.client = new NamespaceRoutesApiImpl(apiClient);
    }

    public NamespaceRoutesApi getClient() {
        return this.client;
    }

    public Observable<NamespaceInfo> getNamespace(NamespaceId namespaceId) {
        Consumer callback = handler -> this.getClient().getNamespace(namespaceId.getIdAsHex(), handler);
        return this.exceptionHandling(this.call(callback).map(this::toNamespaceInfo));
    }

    public Observable<List<NamespaceInfo>> getNamespacesFromAccount(Address address, QueryParams queryParams) {
        return this.getNamespacesFromAccount(address, Optional.of(queryParams));
    }

    public Observable<List<NamespaceInfo>> getNamespacesFromAccount(Address address) {
        return this.getNamespacesFromAccount(address, Optional.empty());
    }

    private Observable<List<NamespaceInfo>> getNamespacesFromAccount(Address address, Optional<QueryParams> queryParams) {
        Consumer callback = handler -> this.client.getNamespacesFromAccount(address.plain(), this.getPageSize(queryParams), this.getId(queryParams), handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toNamespaceInfo).toList().toObservable());
    }

    public Observable<List<NamespaceInfo>> getNamespacesFromAccounts(List<Address> addresses, QueryParams queryParams) {
        return this.getNamespacesFromAccounts(addresses, Optional.of(queryParams));
    }

    public Observable<List<NamespaceInfo>> getNamespacesFromAccounts(List<Address> addresses) {
        return this.getNamespacesFromAccounts(addresses, Optional.empty());
    }

    private Observable<List<NamespaceInfo>> getNamespacesFromAccounts(List<Address> addresses, Optional<QueryParams> queryParams) {
        AccountIds accounts = new AccountIds().addresses(addresses.stream().map(Address::plain).collect(Collectors.toList()));
        Consumer callback = handler -> this.client.getNamespacesFromAccounts(accounts, handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toNamespaceInfo).toList().toObservable());
    }

    public Observable<List<NamespaceName>> getNamespaceNames(List<NamespaceId> namespaceIds) {
        NamespaceIds ids = new NamespaceIds().namespaceIds(namespaceIds.stream().map(NamespaceId::getIdAsHex).collect(Collectors.toList()));
        Consumer callback = handler -> this.client.getNamespacesNames(ids, handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toNamespaceName).toList().toObservable());
    }

    public Observable<MosaicId> getLinkedMosaicId(NamespaceId namespaceId) {
        Consumer callback = handler -> this.getClient().getNamespace(namespaceId.getIdAsHex(), handler);
        return this.exceptionHandling(this.call(callback).map(namespaceInfoDTO -> this.toMosaicId(namespaceInfoDTO.getNamespace())));
    }

    public Observable<Address> getLinkedAddress(NamespaceId namespaceId) {
        Consumer callback = handler -> this.getClient().getNamespace(namespaceId.getIdAsHex(), handler);
        return this.exceptionHandling(this.call(callback).map(namespaceInfoDTO -> this.toAddress(namespaceInfoDTO.getNamespace())));
    }

    private NamespaceName toNamespaceName(NamespaceNameDTO dto) {
        return new NamespaceName(MapperUtils.toNamespaceId((String)dto.getId()), dto.getName(), Optional.ofNullable(MapperUtils.toNamespaceId((String)dto.getParentId())));
    }

    private NamespaceInfo toNamespaceInfo(NamespaceInfoDTO namespaceInfoDTO) {
        return new NamespaceInfo(namespaceInfoDTO.getMeta().getActive().booleanValue(), namespaceInfoDTO.getMeta().getIndex(), namespaceInfoDTO.getMeta().getId(), NamespaceRegistrationType.rawValueOf((int)namespaceInfoDTO.getNamespace().getRegistrationType().getValue()), namespaceInfoDTO.getNamespace().getDepth(), this.extractLevels(namespaceInfoDTO), MapperUtils.toNamespaceId((String)namespaceInfoDTO.getNamespace().getParentId()), new PublicAccount(namespaceInfoDTO.getNamespace().getOwnerPublicKey(), this.getNetworkTypeBlocking()), namespaceInfoDTO.getNamespace().getStartHeight(), namespaceInfoDTO.getNamespace().getEndHeight(), this.extractAlias(namespaceInfoDTO.getNamespace()));
    }

    private MosaicId toMosaicId(NamespaceDTO namespaceDTO) {
        MosaicId mosaicId = null;
        if (namespaceDTO.getAlias() != null && AliasType.MOSAIC.getValue().equals(namespaceDTO.getAlias().getType().getValue())) {
            mosaicId = MapperUtils.toMosaicId((String)namespaceDTO.getAlias().getMosaicId());
        }
        return mosaicId;
    }

    private Address toAddress(NamespaceDTO namespaceDTO) {
        String rawAddress;
        Address address = null;
        if (namespaceDTO.getAlias() != null && AliasType.ADDRESS.getValue().equals(namespaceDTO.getAlias().getType().getValue()) && (rawAddress = namespaceDTO.getAlias().getAddress()) != null) {
            address = MapperUtils.toAddressFromRawAddress((String)rawAddress);
        }
        return address;
    }

    private List<NamespaceId> extractLevels(NamespaceInfoDTO namespaceInfoDTO) {
        ArrayList<NamespaceId> levels = new ArrayList<NamespaceId>();
        if (namespaceInfoDTO.getNamespace().getLevel0() != null) {
            levels.add(MapperUtils.toNamespaceId((String)namespaceInfoDTO.getNamespace().getLevel0()));
        }
        if (namespaceInfoDTO.getNamespace().getLevel1() != null) {
            levels.add(MapperUtils.toNamespaceId((String)namespaceInfoDTO.getNamespace().getLevel1()));
        }
        if (namespaceInfoDTO.getNamespace().getLevel2() != null) {
            levels.add(MapperUtils.toNamespaceId((String)namespaceInfoDTO.getNamespace().getLevel2()));
        }
        return levels;
    }

    private Alias extractAlias(NamespaceDTO namespaceDTO) {
        EmptyAlias alias = new EmptyAlias();
        if (namespaceDTO.getAlias() != null) {
            if (namespaceDTO.getAlias().getType().getValue().equals(AliasType.MOSAIC.getValue())) {
                return new MosaicAlias(this.toMosaicId(namespaceDTO));
            }
            if (namespaceDTO.getAlias().getType().getValue().equals(AliasType.ADDRESS.getValue())) {
                return new AddressAlias(this.toAddress(namespaceDTO));
            }
        }
        return alias;
    }
}

