/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx;

import io.nem.core.utils.ConvertUtils;
import io.nem.sdk.api.MetadataRepository;
import io.nem.sdk.api.QueryParams;
import io.nem.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.sdk.model.account.Address;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.metadata.Metadata;
import io.nem.sdk.model.metadata.MetadataEntry;
import io.nem.sdk.model.metadata.MetadataType;
import io.nem.sdk.model.mosaic.MosaicId;
import io.nem.sdk.model.namespace.NamespaceId;
import io.nem.sdk.openapi.vertx.api.MetadataRoutesApi;
import io.nem.sdk.openapi.vertx.api.MetadataRoutesApiImpl;
import io.nem.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.sdk.openapi.vertx.model.MetadataDTO;
import io.nem.sdk.openapi.vertx.model.MetadataEntriesDTO;
import io.nem.sdk.openapi.vertx.model.MetadataEntryDTO;
import io.reactivex.Observable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class MetadataRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements MetadataRepository {
    private final MetadataRoutesApi client;

    public MetadataRepositoryVertxImpl(ApiClient apiClient, Supplier<NetworkType> networkType) {
        super(apiClient, networkType);
        this.client = new MetadataRoutesApiImpl(apiClient);
    }

    public Observable<List<Metadata>> getAccountMetadata(Address address, Optional<QueryParams> queryParams) {
        Consumer<Handler<AsyncResult<MetadataEntriesDTO>>> callback = handler -> this.getClient().getAccountMetadata(address.plain(), this.getPageSize(queryParams), this.getId(queryParams), this.getOrder(queryParams), handler);
        return this.handleList(callback);
    }

    public Observable<List<Metadata>> getAccountMetadataByKey(Address address, BigInteger key) {
        Consumer<Handler<AsyncResult<MetadataEntriesDTO>>> callback = handler -> this.getClient().getAccountMetadataByKey(address.plain(), this.toHex(key), handler);
        return this.handleList(callback);
    }

    public Observable<List<Metadata>> getMosaicMetadata(MosaicId mosaicId, Optional<QueryParams> queryParams) {
        Consumer<Handler<AsyncResult<MetadataEntriesDTO>>> callback = handler -> this.getClient().getMosaicMetadata(mosaicId.getIdAsHex(), this.getPageSize(queryParams), this.getId(queryParams), this.getOrder(queryParams), handler);
        return this.handleList(callback);
    }

    public Observable<List<Metadata>> getMosaicMetadataByKey(MosaicId mosaicId, BigInteger key) {
        Consumer<Handler<AsyncResult<MetadataEntriesDTO>>> callback = handler -> this.getClient().getMosaicMetadataByKey(mosaicId.getIdAsHex(), this.toHex(key), handler);
        return this.handleList(callback);
    }

    public Observable<Metadata> getAccountMetadataByKeyAndSender(Address address, BigInteger key, String publicKey) {
        Consumer<Handler<AsyncResult<MetadataDTO>>> callback = handler -> this.getClient().getAccountMetadataByKeyAndSender(address.plain(), this.toHex(key), publicKey, handler);
        return this.handleOne(callback);
    }

    public Observable<Metadata> getMosaicMetadataByKeyAndSender(MosaicId mosaicId, BigInteger key, String publicKey) {
        Consumer<Handler<AsyncResult<MetadataDTO>>> callback = handler -> this.getClient().getMosaicMetadataByKeyAndSender(mosaicId.getIdAsHex(), this.toHex(key), publicKey, handler);
        return this.handleOne(callback);
    }

    public Observable<List<Metadata>> getNamespaceMetadata(NamespaceId namespaceId, Optional<QueryParams> queryParams) {
        Consumer<Handler<AsyncResult<MetadataEntriesDTO>>> callback = handler -> this.getClient().getNamespaceMetadata(namespaceId.getIdAsHex(), this.getPageSize(queryParams), this.getId(queryParams), this.getOrder(queryParams), handler);
        return this.handleList(callback);
    }

    public Observable<List<Metadata>> getNamespaceMetadataByKey(NamespaceId namespaceId, BigInteger key) {
        Consumer<Handler<AsyncResult<MetadataEntriesDTO>>> callback = handler -> this.getClient().getNamespaceMetadataByKey(namespaceId.getIdAsHex(), this.toHex(key), handler);
        return this.handleList(callback);
    }

    public Observable<Metadata> getNamespaceMetadataByKeyAndSender(NamespaceId namespaceId, BigInteger key, String publicKey) {
        Consumer<Handler<AsyncResult<MetadataDTO>>> callback = handler -> this.getClient().getNamespaceMetadataByKeyAndSender(namespaceId.getIdAsHex(), this.toHex(key), publicKey, handler);
        return this.handleOne(callback);
    }

    public MetadataRoutesApi getClient() {
        return this.client;
    }

    private Observable<List<Metadata>> handleList(Consumer<Handler<AsyncResult<MetadataEntriesDTO>>> callback) {
        return this.exceptionHandling(this.call(callback).map(MetadataEntriesDTO::getMetadataEntries).flatMapIterable(item -> item).map(this::toMetadata).toList().toObservable());
    }

    private Observable<Metadata> handleOne(Consumer<Handler<AsyncResult<MetadataDTO>>> callback) {
        return this.exceptionHandling(this.call(callback).map(this::toMetadata));
    }

    private Metadata toMetadata(MetadataDTO dto) {
        MetadataEntryDTO entryDto = dto.getMetadataEntry();
        MetadataEntry metadataEntry = new MetadataEntry(entryDto.getCompositeHash(), entryDto.getSenderPublicKey(), entryDto.getTargetPublicKey(), new BigInteger(entryDto.getScopedMetadataKey(), 16), MetadataType.rawValueOf((int)entryDto.getMetadataType().getValue()), entryDto.getValueSize(), ConvertUtils.fromHexToString((String)entryDto.getValue()), Optional.ofNullable(Objects.toString(entryDto.getTargetId(), null)));
        return new Metadata(dto.getId(), metadataEntry);
    }

    private String toHex(BigInteger key) {
        return ConvertUtils.toSize16Hex((BigInteger)key);
    }
}

