/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx;

import io.nem.sdk.api.ChainRepository;
import io.nem.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.sdk.model.blockchain.BlockchainScore;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.openapi.vertx.api.ChainRoutesApi;
import io.nem.sdk.openapi.vertx.api.ChainRoutesApiImpl;
import io.nem.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.sdk.openapi.vertx.model.HeightInfoDTO;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ChainRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements ChainRepository {
    private final ChainRoutesApi client;

    public ChainRepositoryVertxImpl(ApiClient apiClient, Supplier<NetworkType> networkType) {
        super(apiClient, networkType);
        this.client = new ChainRoutesApiImpl(apiClient);
    }

    public ChainRoutesApi getClient() {
        return this.client;
    }

    public Observable<BigInteger> getBlockchainHeight() {
        Consumer callback = arg_0 -> ((ChainRoutesApi)this.client).getBlockchainHeight(arg_0);
        return this.exceptionHandling(this.call(callback).map(HeightInfoDTO::getHeight));
    }

    public Observable<BlockchainScore> getChainScore() {
        Consumer callback = arg_0 -> ((ChainRoutesApi)this.client).getChainScore(arg_0);
        return this.exceptionHandling(this.call(callback).map(blockchainScoreDTO -> new BlockchainScore(blockchainScoreDTO.getScoreLow(), blockchainScoreDTO.getScoreHigh())));
    }
}

