/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx.mappers;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.sdk.model.account.UnresolvedAddress;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.message.Message;
import io.nem.sdk.model.message.MessageType;
import io.nem.sdk.model.message.PlainMessage;
import io.nem.sdk.model.mosaic.Mosaic;
import io.nem.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.TransactionFactory;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.model.transaction.TransferTransaction;
import io.nem.sdk.model.transaction.TransferTransactionFactory;
import io.nem.sdk.openapi.vertx.model.MessageDTO;
import io.nem.sdk.openapi.vertx.model.MessageTypeEnum;
import io.nem.sdk.openapi.vertx.model.TransferTransactionDTO;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;

class TransferTransactionMapper
extends AbstractTransactionMapper<TransferTransactionDTO, TransferTransaction> {
    public TransferTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.TRANSFER, TransferTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<TransferTransaction> createFactory(NetworkType networkType, TransferTransactionDTO transaction) {
        List<Object> mosaics = new ArrayList();
        if (transaction.getMosaics() != null) {
            mosaics = transaction.getMosaics().stream().map((? super T mosaic) -> new Mosaic((UnresolvedMosaicId)MapperUtils.toMosaicId((String)mosaic.getId()), mosaic.getAmount())).collect(Collectors.toList());
        }
        Message message = Optional.ofNullable(transaction.getMessage()).map((? super T m) -> Message.createFromPayload((MessageType)MessageType.rawValueOf((int)m.getType().getValue()), (String)m.getPayload())).orElse((Message)PlainMessage.Empty);
        return TransferTransactionFactory.create((NetworkType)networkType, (UnresolvedAddress)MapperUtils.toUnresolvedAddress((String)transaction.getRecipientAddress()), mosaics, (Message)message);
    }

    @Override
    protected void copyToDto(TransferTransaction transaction, TransferTransactionDTO dto) {
        List<Object> mosaics = new ArrayList();
        if (transaction.getMosaics() != null) {
            mosaics = transaction.getMosaics().stream().map((? super T mosaic) -> {
                io.nem.sdk.openapi.vertx.model.Mosaic mosaicDto = new io.nem.sdk.openapi.vertx.model.Mosaic();
                mosaicDto.setAmount(mosaic.getAmount());
                mosaicDto.setId(MapperUtils.getIdAsHex((UnresolvedMosaicId)mosaic.getId()));
                return mosaicDto;
            }).collect(Collectors.toList());
        }
        MessageDTO message = null;
        if (transaction.getMessage() != null) {
            message = new MessageDTO();
            message.setType(MessageTypeEnum.NUMBER_0);
            message.setPayload(Hex.encodeHexString((byte[])transaction.getMessage().getPayload().getBytes(StandardCharsets.UTF_8)));
        }
        dto.setRecipientAddress(transaction.getRecipient().encoded());
        dto.setMosaics(mosaics);
        dto.setMessage(message);
    }
}

