/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx.mappers;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.sdk.model.account.UnresolvedAddress;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.LockHashAlgorithmType;
import io.nem.sdk.model.transaction.SecretProofTransaction;
import io.nem.sdk.model.transaction.SecretProofTransactionFactory;
import io.nem.sdk.model.transaction.TransactionFactory;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.vertx.model.LockHashAlgorithmEnum;
import io.nem.sdk.openapi.vertx.model.SecretProofTransactionDTO;

class SecretProofTransactionMapper
extends AbstractTransactionMapper<SecretProofTransactionDTO, SecretProofTransaction> {
    public SecretProofTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.SECRET_PROOF, SecretProofTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<SecretProofTransaction> createFactory(NetworkType networkType, SecretProofTransactionDTO transaction) {
        return SecretProofTransactionFactory.create((NetworkType)networkType, (LockHashAlgorithmType)LockHashAlgorithmType.rawValueOf((int)transaction.getHashAlgorithm().getValue()), (UnresolvedAddress)MapperUtils.toUnresolvedAddress((String)transaction.getRecipientAddress()), (String)transaction.getSecret(), (String)transaction.getProof());
    }

    @Override
    protected void copyToDto(SecretProofTransaction transaction, SecretProofTransactionDTO dto) {
        dto.setHashAlgorithm(LockHashAlgorithmEnum.fromValue((Integer)transaction.getHashType().getValue()));
        dto.setRecipientAddress(transaction.getRecipient().encoded());
        dto.setSecret(transaction.getSecret());
        dto.setProof(transaction.getProof());
    }
}

