/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx.mappers;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.sdk.model.account.UnresolvedAddress;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.MosaicAddressRestrictionTransaction;
import io.nem.sdk.model.transaction.MosaicAddressRestrictionTransactionFactory;
import io.nem.sdk.model.transaction.TransactionFactory;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.vertx.model.MosaicAddressRestrictionTransactionDTO;
import java.math.BigInteger;

class MosaicAddressRestrictionTransactionMapper
extends AbstractTransactionMapper<MosaicAddressRestrictionTransactionDTO, MosaicAddressRestrictionTransaction> {
    public MosaicAddressRestrictionTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.MOSAIC_ADDRESS_RESTRICTION, MosaicAddressRestrictionTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<MosaicAddressRestrictionTransaction> createFactory(NetworkType networkType, MosaicAddressRestrictionTransactionDTO transaction) {
        return MosaicAddressRestrictionTransactionFactory.create((NetworkType)networkType, (UnresolvedMosaicId)MapperUtils.toUnresolvedMosaicId((String)transaction.getMosaicId()), (BigInteger)MapperUtils.fromHexToBigInteger((String)transaction.getRestrictionKey()), (UnresolvedAddress)MapperUtils.toUnresolvedAddress((String)transaction.getTargetAddress()), (BigInteger)transaction.getNewRestrictionValue()).previousRestrictionValue(transaction.getPreviousRestrictionValue());
    }

    @Override
    protected void copyToDto(MosaicAddressRestrictionTransaction transaction, MosaicAddressRestrictionTransactionDTO dto) {
        dto.setMosaicId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getMosaicId()));
        dto.setRestrictionKey(transaction.getRestrictionKey().toString(16));
        dto.setTargetAddress(transaction.getTargetAddress().encoded());
        dto.setPreviousRestrictionValue(transaction.getPreviousRestrictionValue());
        dto.setNewRestrictionValue(transaction.getNewRestrictionValue());
    }
}

