/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx.mappers;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.sdk.model.account.Address;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.sdk.model.namespace.AliasAction;
import io.nem.sdk.model.namespace.NamespaceId;
import io.nem.sdk.model.transaction.AddressAliasTransaction;
import io.nem.sdk.model.transaction.AddressAliasTransactionFactory;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.vertx.model.AddressAliasTransactionDTO;
import io.nem.sdk.openapi.vertx.model.AliasActionEnum;

class AddressAliasTransactionMapper
extends AbstractTransactionMapper<AddressAliasTransactionDTO, AddressAliasTransaction> {
    public AddressAliasTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.ADDRESS_ALIAS, AddressAliasTransactionDTO.class);
    }

    protected AddressAliasTransactionFactory createFactory(NetworkType networkType, AddressAliasTransactionDTO transaction) {
        NamespaceId namespaceId = MapperUtils.toNamespaceId((String)transaction.getNamespaceId());
        AliasAction aliasAction = AliasAction.rawValueOf((byte)transaction.getAliasAction().getValue().byteValue());
        return AddressAliasTransactionFactory.create((NetworkType)networkType, (AliasAction)aliasAction, (NamespaceId)namespaceId, (Address)MapperUtils.toAddressFromEncoded((String)transaction.getAddress()));
    }

    @Override
    protected void copyToDto(AddressAliasTransaction transaction, AddressAliasTransactionDTO dto) {
        dto.setAddress(transaction.getAddress().encoded());
        dto.setNamespaceId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getNamespaceId()));
        dto.setAliasAction(AliasActionEnum.fromValue((Integer)Integer.valueOf(transaction.getAliasAction().getValue())));
    }
}

