/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx.mappers;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.sdk.model.transaction.AccountMosaicRestrictionTransaction;
import io.nem.sdk.model.transaction.AccountMosaicRestrictionTransactionFactory;
import io.nem.sdk.model.transaction.AccountRestrictionModification;
import io.nem.sdk.model.transaction.AccountRestrictionModificationAction;
import io.nem.sdk.model.transaction.AccountRestrictionType;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.vertx.model.AccountMosaicRestrictionModificationDTO;
import io.nem.sdk.openapi.vertx.model.AccountMosaicRestrictionTransactionDTO;
import io.nem.sdk.openapi.vertx.model.AccountRestrictionModificationActionEnum;
import io.nem.sdk.openapi.vertx.model.AccountRestrictionTypeEnum;
import java.util.List;
import java.util.stream.Collectors;

public class AccountMosaicRestrictionTransactionMapper
extends AbstractTransactionMapper<AccountMosaicRestrictionTransactionDTO, AccountMosaicRestrictionTransaction> {
    public AccountMosaicRestrictionTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.ACCOUNT_MOSAIC_RESTRICTION, AccountMosaicRestrictionTransactionDTO.class);
    }

    protected AccountMosaicRestrictionTransactionFactory createFactory(NetworkType networkType, AccountMosaicRestrictionTransactionDTO transaction) {
        AccountRestrictionType restrictionType = AccountRestrictionType.rawValueOf((int)transaction.getRestrictionType().getValue());
        List modifications = transaction.getModifications().stream().map(this::toModification).collect(Collectors.toList());
        return AccountMosaicRestrictionTransactionFactory.create((NetworkType)networkType, (AccountRestrictionType)restrictionType, modifications);
    }

    private AccountRestrictionModification<UnresolvedMosaicId> toModification(AccountMosaicRestrictionModificationDTO dto) {
        AccountRestrictionModificationAction modificationAction = AccountRestrictionModificationAction.rawValueOf((byte)dto.getModificationAction().getValue().byteValue());
        return AccountRestrictionModification.createForMosaic((AccountRestrictionModificationAction)modificationAction, (UnresolvedMosaicId)MapperUtils.toUnresolvedMosaicId((String)dto.getValue()));
    }

    @Override
    protected void copyToDto(AccountMosaicRestrictionTransaction transaction, AccountMosaicRestrictionTransactionDTO dto) {
        dto.setRestrictionType(AccountRestrictionTypeEnum.fromValue((Integer)transaction.getRestrictionType().getValue()));
        dto.setModifications(transaction.getModifications().stream().map(this::toModification).collect(Collectors.toList()));
    }

    private AccountMosaicRestrictionModificationDTO toModification(AccountRestrictionModification<UnresolvedMosaicId> model) {
        AccountMosaicRestrictionModificationDTO dto = new AccountMosaicRestrictionModificationDTO();
        dto.setModificationAction(AccountRestrictionModificationActionEnum.fromValue((Integer)Integer.valueOf(model.getModificationAction().getValue())));
        dto.setValue(MapperUtils.getIdAsHex((UnresolvedMosaicId)((UnresolvedMosaicId)model.getValue())));
        return dto;
    }
}

