/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx;

import io.nem.core.utils.Suppliers;
import io.nem.sdk.api.AccountRepository;
import io.nem.sdk.api.BlockRepository;
import io.nem.sdk.api.ChainRepository;
import io.nem.sdk.api.DiagnosticRepository;
import io.nem.sdk.api.JsonSerialization;
import io.nem.sdk.api.MetadataRepository;
import io.nem.sdk.api.MosaicRepository;
import io.nem.sdk.api.NamespaceRepository;
import io.nem.sdk.api.NetworkRepository;
import io.nem.sdk.api.NodeRepository;
import io.nem.sdk.api.RepositoryCallException;
import io.nem.sdk.api.RepositoryFactory;
import io.nem.sdk.api.RestrictionRepository;
import io.nem.sdk.api.TransactionRepository;
import io.nem.sdk.infrastructure.Listener;
import io.nem.sdk.infrastructure.vertx.AccountRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.BlockRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.ChainRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.DiagnosticRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.JsonHelperJackson2;
import io.nem.sdk.infrastructure.vertx.JsonSerializationVertx;
import io.nem.sdk.infrastructure.vertx.ListenerVertx;
import io.nem.sdk.infrastructure.vertx.MetadataRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.MosaicRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.NamespaceRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.NetworkRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.NodeRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.RestrictionRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.TransactionRepositoryVertxImpl;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.openapi.vertx.invoker.ApiClient;
import io.vertx.core.Vertx;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.WebClient;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class RepositoryFactoryVertxImpl
implements RepositoryFactory {
    private final ApiClient apiClient;
    private final Supplier<NetworkType> networkType;
    private final WebClient webClient;
    private final String baseUrl;
    private final Vertx vertx;

    public RepositoryFactoryVertxImpl(String baseUrl) {
        this.baseUrl = baseUrl;
        this.vertx = Vertx.vertx();
        this.webClient = WebClient.create((Vertx)this.vertx);
        this.apiClient = new ApiClient(this.vertx, new JsonObject().put("basePath", baseUrl)){

            public synchronized WebClient getWebClient() {
                return RepositoryFactoryVertxImpl.this.webClient;
            }
        };
        JsonHelperJackson2.configureMapper(this.apiClient.getObjectMapper());
        JsonHelperJackson2.configureMapper(Json.mapper);
        this.networkType = Suppliers.memoize(this::loadNetworkType);
        this.networkType.get();
    }

    protected NetworkType loadNetworkType() {
        try {
            return (NetworkType)io.nem.core.utils.ExceptionUtils.propagate(() -> {
                NetworkRepositoryVertxImpl networkRepository = new NetworkRepositoryVertxImpl(this.apiClient);
                return (NetworkType)networkRepository.getNetworkType().toFuture().get(10L, TimeUnit.SECONDS);
            });
        }
        catch (Exception e) {
            throw new RepositoryCallException("Unable to load NetworkType. Error: " + ExceptionUtils.getMessage((Throwable)e), (Throwable)e);
        }
    }

    public AccountRepository createAccountRepository() {
        return new AccountRepositoryVertxImpl(this.apiClient, this.networkType);
    }

    public BlockRepository createBlockRepository() {
        return new BlockRepositoryVertxImpl(this.apiClient, this.networkType);
    }

    public ChainRepository createChainRepository() {
        return new ChainRepositoryVertxImpl(this.apiClient, this.networkType);
    }

    public DiagnosticRepository createDiagnosticRepository() {
        return new DiagnosticRepositoryVertxImpl(this.apiClient, this.networkType);
    }

    public MosaicRepository createMosaicRepository() {
        return new MosaicRepositoryVertxImpl(this.apiClient, this.networkType);
    }

    public NamespaceRepository createNamespaceRepository() {
        return new NamespaceRepositoryVertxImpl(this.apiClient, this.networkType);
    }

    public NetworkRepository createNetworkRepository() {
        return new NetworkRepositoryVertxImpl(this.apiClient);
    }

    public NodeRepository createNodeRepository() {
        return new NodeRepositoryVertxImpl(this.apiClient, this.networkType);
    }

    public TransactionRepository createTransactionRepository() {
        return new TransactionRepositoryVertxImpl(this.apiClient, this.networkType);
    }

    public MetadataRepository createMetadataRepository() {
        return new MetadataRepositoryVertxImpl(this.apiClient, this.networkType);
    }

    public RestrictionRepository createRestrictionRepository() {
        return new RestrictionRepositoryVertxImpl(this.apiClient, this.networkType);
    }

    public Listener createListener() {
        return new ListenerVertx(this.vertx.createHttpClient(), this.baseUrl);
    }

    public JsonSerialization createJsonSerialization() {
        return new JsonSerializationVertx(this.apiClient.getObjectMapper());
    }

    public void close() {
        this.vertx.close();
        try {
            this.webClient.close();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

