/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.model.account.Address;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.MosaicId;
import io.nem.sdk.model.namespace.AddressAlias;
import io.nem.sdk.model.namespace.MosaicAlias;
import io.nem.sdk.model.receipt.ArtifactExpiryReceipt;
import io.nem.sdk.model.receipt.BalanceChangeReceipt;
import io.nem.sdk.model.receipt.BalanceTransferReceipt;
import io.nem.sdk.model.receipt.InflationReceipt;
import io.nem.sdk.model.receipt.Receipt;
import io.nem.sdk.model.receipt.ReceiptSource;
import io.nem.sdk.model.receipt.ReceiptType;
import io.nem.sdk.model.receipt.ReceiptVersion;
import io.nem.sdk.model.receipt.ResolutionEntry;
import io.nem.sdk.model.receipt.ResolutionStatement;
import io.nem.sdk.model.receipt.Statement;
import io.nem.sdk.model.receipt.TransactionStatement;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.openapi.vertx.model.ArtifactExpiryReceiptDTO;
import io.nem.sdk.openapi.vertx.model.BalanceChangeReceiptDTO;
import io.nem.sdk.openapi.vertx.model.BalanceTransferReceiptDTO;
import io.nem.sdk.openapi.vertx.model.InflationReceiptDTO;
import io.nem.sdk.openapi.vertx.model.ResolutionStatementBodyDTO;
import io.nem.sdk.openapi.vertx.model.ResolutionStatementDTO;
import io.nem.sdk.openapi.vertx.model.StatementsDTO;
import io.nem.sdk.openapi.vertx.model.TransactionStatementBodyDTO;
import io.nem.sdk.openapi.vertx.model.TransactionStatementDTO;
import java.util.List;
import java.util.stream.Collectors;

public class ReceiptMappingVertx {
    private final JsonHelper jsonHelper;

    public ReceiptMappingVertx(JsonHelper jsonHelper) {
        this.jsonHelper = jsonHelper;
    }

    public Statement createStatementFromDto(StatementsDTO input, NetworkType networkType) {
        List transactionStatements = input.getTransactionStatements().stream().map(receiptDto -> this.createTransactionStatement((TransactionStatementDTO)receiptDto, networkType)).collect(Collectors.toList());
        List addressResolutionStatements = input.getAddressResolutionStatements().stream().map(this::createAddressResolutionStatementFromDto).collect(Collectors.toList());
        List mosaicResolutionStatements = input.getMosaicResolutionStatements().stream().map(this::createMosaicResolutionStatementFromDto).collect(Collectors.toList());
        return new Statement(transactionStatements, addressResolutionStatements, mosaicResolutionStatements);
    }

    public ResolutionStatement<Address> createAddressResolutionStatementFromDto(ResolutionStatementDTO receiptDto) {
        ResolutionStatementBodyDTO statement = receiptDto.getStatement();
        return new ResolutionStatement(statement.getHeight(), (Object)MapperUtils.toAddressFromEncoded((String)statement.getUnresolved().toString()), statement.getResolutionEntries().stream().map(entry -> new ResolutionEntry((Object)new AddressAlias(MapperUtils.toAddressFromEncoded((String)entry.getResolved().toString())), new ReceiptSource(entry.getSource().getPrimaryId().intValue(), entry.getSource().getSecondaryId().intValue()), ReceiptType.ADDRESS_ALIAS_RESOLUTION)).collect(Collectors.toList()));
    }

    public ResolutionStatement<MosaicId> createMosaicResolutionStatementFromDto(ResolutionStatementDTO receiptDto) {
        return new ResolutionStatement(receiptDto.getStatement().getHeight(), (Object)MapperUtils.toMosaicId((String)receiptDto.getStatement().getUnresolved().toString()), receiptDto.getStatement().getResolutionEntries().stream().map(entry -> new ResolutionEntry((Object)new MosaicAlias(MapperUtils.toMosaicId((String)entry.getResolved().toString())), new ReceiptSource(entry.getSource().getPrimaryId().intValue(), entry.getSource().getSecondaryId().intValue()), ReceiptType.MOSAIC_ALIAS_RESOLUTION)).collect(Collectors.toList()));
    }

    public TransactionStatement createTransactionStatement(TransactionStatementDTO input, NetworkType networkType) {
        TransactionStatementBodyDTO statement = input.getStatement();
        return new TransactionStatement(statement.getHeight(), new ReceiptSource(statement.getSource().getPrimaryId().intValue(), statement.getSource().getSecondaryId().intValue()), statement.getReceipts().stream().map(receipt -> this.createReceiptFromDto(receipt, networkType)).collect(Collectors.toList()));
    }

    public Receipt createReceiptFromDto(Object receiptDto, NetworkType networkType) {
        ReceiptType type = ReceiptType.rawValueOf((int)this.jsonHelper.getInteger(receiptDto, new String[]{"type"}));
        switch (type) {
            case HARVEST_FEE: 
            case LOCK_HASH_CREATED: 
            case LOCK_HASH_COMPLETED: 
            case LOCK_HASH_EXPIRED: 
            case LOCK_SECRET_CREATED: 
            case LOCK_SECRET_COMPLETED: 
            case LOCK_SECRET_EXPIRED: {
                return this.createBalanceChangeReceipt((BalanceChangeReceiptDTO)this.jsonHelper.convert(receiptDto, BalanceChangeReceiptDTO.class), networkType);
            }
            case MOSAIC_RENTAL_FEE: 
            case NAMESPACE_RENTAL_FEE: {
                return this.createBalanceTransferRecipient((BalanceTransferReceiptDTO)this.jsonHelper.convert(receiptDto, BalanceTransferReceiptDTO.class), networkType);
            }
            case MOSAIC_EXPIRED: 
            case NAMESPACE_EXPIRED: {
                return this.createArtifactExpiryReceipt((ArtifactExpiryReceiptDTO)this.jsonHelper.convert(receiptDto, ArtifactExpiryReceiptDTO.class), type);
            }
            case INFLATION: {
                return this.createInflationReceipt((InflationReceiptDTO)this.jsonHelper.convert(receiptDto, InflationReceiptDTO.class));
            }
        }
        throw new IllegalArgumentException("Receipt type: " + type.name() + " not valid");
    }

    public ArtifactExpiryReceipt<MosaicId> createArtifactExpiryReceipt(ArtifactExpiryReceiptDTO receipt, ReceiptType type) {
        return new ArtifactExpiryReceipt((Object)MapperUtils.toMosaicId((String)receipt.getArtifactId().toString()), type, ReceiptVersion.ARTIFACT_EXPIRY);
    }

    public BalanceChangeReceipt createBalanceChangeReceipt(BalanceChangeReceiptDTO receipt, NetworkType networkType) {
        return new BalanceChangeReceipt(PublicAccount.createFromPublicKey((String)receipt.getTargetPublicKey(), (NetworkType)networkType), new MosaicId(receipt.getMosaicId()), receipt.getAmount(), ReceiptType.rawValueOf((int)receipt.getType().getValue()), ReceiptVersion.BALANCE_CHANGE);
    }

    public BalanceTransferReceipt<Address> createBalanceTransferRecipient(BalanceTransferReceiptDTO receipt, NetworkType networkType) {
        return new BalanceTransferReceipt(PublicAccount.createFromPublicKey((String)receipt.getSenderPublicKey(), (NetworkType)networkType), (Object)MapperUtils.toAddressFromEncoded((String)receipt.getRecipientAddress()), new MosaicId(receipt.getMosaicId()), receipt.getAmount(), ReceiptType.rawValueOf((int)receipt.getType().getValue()), ReceiptVersion.BALANCE_TRANSFER);
    }

    public InflationReceipt createInflationReceipt(InflationReceiptDTO receipt) {
        return new InflationReceipt(new MosaicId(receipt.getMosaicId()), receipt.getAmount(), ReceiptType.rawValueOf((int)receipt.getType().getValue()), ReceiptVersion.INFLATION_RECEIPT);
    }
}

