/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.api.MosaicRepository;
import io.nem.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.MosaicFlags;
import io.nem.sdk.model.mosaic.MosaicId;
import io.nem.sdk.model.mosaic.MosaicInfo;
import io.nem.sdk.model.mosaic.MosaicNames;
import io.nem.sdk.model.namespace.NamespaceName;
import io.nem.sdk.openapi.vertx.api.MosaicRoutesApi;
import io.nem.sdk.openapi.vertx.api.MosaicRoutesApiImpl;
import io.nem.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.sdk.openapi.vertx.model.MosaicDTO;
import io.nem.sdk.openapi.vertx.model.MosaicIds;
import io.nem.sdk.openapi.vertx.model.MosaicInfoDTO;
import io.nem.sdk.openapi.vertx.model.MosaicNamesDTO;
import io.nem.sdk.openapi.vertx.model.MosaicsNamesDTO;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class MosaicRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements MosaicRepository {
    private final MosaicRoutesApi client;

    public MosaicRepositoryVertxImpl(ApiClient apiClient, Supplier<NetworkType> networkType) {
        super(apiClient, networkType);
        this.client = new MosaicRoutesApiImpl(apiClient);
    }

    public MosaicRoutesApi getClient() {
        return this.client;
    }

    public Observable<MosaicInfo> getMosaic(MosaicId mosaicId) {
        Consumer callback = handler -> this.getClient().getMosaic(mosaicId.getIdAsHex(), handler);
        return this.exceptionHandling(this.call(callback).map(this::createMosaicInfo));
    }

    public Observable<List<MosaicInfo>> getMosaics(List<MosaicId> ids) {
        MosaicIds mosaicIds = new MosaicIds();
        mosaicIds.mosaicIds(ids.stream().map(MosaicId::getIdAsHex).collect(Collectors.toList()));
        Consumer callback = handler -> this.getClient().getMosaics(mosaicIds, handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::createMosaicInfo).toList().toObservable());
    }

    private MosaicInfo createMosaicInfo(MosaicInfoDTO mosaicInfoDTO) {
        NetworkType networkType = this.getNetworkTypeBlocking();
        return MosaicInfo.create((MosaicId)MapperUtils.toMosaicId((String)mosaicInfoDTO.getMosaic().getId()), (BigInteger)mosaicInfoDTO.getMosaic().getSupply(), (BigInteger)mosaicInfoDTO.getMosaic().getStartHeight(), (PublicAccount)new PublicAccount(mosaicInfoDTO.getMosaic().getOwnerPublicKey(), networkType), (Integer)mosaicInfoDTO.getMosaic().getRevision(), (MosaicFlags)MosaicRepositoryVertxImpl.extractMosaicFlags(mosaicInfoDTO.getMosaic()), (int)mosaicInfoDTO.getMosaic().getDivisibility(), (BigInteger)mosaicInfoDTO.getMosaic().getDuration());
    }

    public Observable<List<MosaicNames>> getMosaicsNames(List<MosaicId> ids) {
        MosaicIds mosaicIds = new MosaicIds();
        mosaicIds.mosaicIds(ids.stream().map(MosaicId::getIdAsHex).collect(Collectors.toList()));
        Consumer callback = handler -> this.getClient().getMosaicsNames(mosaicIds, handler);
        return this.exceptionHandling(this.call(callback).map(MosaicsNamesDTO::getMosaicNames).flatMapIterable(item -> item).map(this::toMosaicNames).toList().toObservable());
    }

    private MosaicNames toMosaicNames(MosaicNamesDTO dto) {
        return new MosaicNames(MapperUtils.toMosaicId((String)dto.getMosaicId()), dto.getNames().stream().map(NamespaceName::new).collect(Collectors.toList()));
    }

    public static MosaicFlags extractMosaicFlags(MosaicDTO mosaicDTO) {
        return MosaicFlags.create((int)mosaicDTO.getFlags());
    }
}

