/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.vertx;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.api.AccountRepository;
import io.nem.sdk.api.QueryParams;
import io.nem.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.sdk.infrastructure.vertx.mappers.GeneralTransactionMapper;
import io.nem.sdk.infrastructure.vertx.mappers.TransactionMapper;
import io.nem.sdk.model.account.AccountInfo;
import io.nem.sdk.model.account.AccountNames;
import io.nem.sdk.model.account.AccountType;
import io.nem.sdk.model.account.Address;
import io.nem.sdk.model.account.MultisigAccountGraphInfo;
import io.nem.sdk.model.account.MultisigAccountInfo;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.Mosaic;
import io.nem.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.sdk.model.namespace.NamespaceName;
import io.nem.sdk.model.transaction.AggregateTransaction;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.openapi.vertx.api.AccountRoutesApi;
import io.nem.sdk.openapi.vertx.api.AccountRoutesApiImpl;
import io.nem.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.sdk.openapi.vertx.model.AccountDTO;
import io.nem.sdk.openapi.vertx.model.AccountIds;
import io.nem.sdk.openapi.vertx.model.AccountInfoDTO;
import io.nem.sdk.openapi.vertx.model.AccountNamesDTO;
import io.nem.sdk.openapi.vertx.model.AccountsNamesDTO;
import io.nem.sdk.openapi.vertx.model.MultisigAccountGraphInfoDTO;
import io.nem.sdk.openapi.vertx.model.MultisigAccountInfoDTO;
import io.nem.sdk.openapi.vertx.model.MultisigDTO;
import io.nem.sdk.openapi.vertx.model.TransactionInfoDTO;
import io.reactivex.Observable;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class AccountRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements AccountRepository {
    private final AccountRoutesApi client;
    private final TransactionMapper transactionMapper;

    public AccountRepositoryVertxImpl(ApiClient apiClient, Supplier<NetworkType> networkType) {
        super(apiClient, networkType);
        this.client = new AccountRoutesApiImpl(apiClient);
        this.transactionMapper = new GeneralTransactionMapper(this.getJsonHelper());
    }

    public Observable<AccountInfo> getAccountInfo(Address address) {
        Consumer callback = handler -> this.getClient().getAccountInfo(address.plain(), handler);
        return this.exceptionHandling(this.call(callback).map(AccountInfoDTO::getAccount).map(this::toAccountInfo));
    }

    public Observable<List<AccountNames>> getAccountsNames(List<Address> addresses) {
        AccountIds accountIds = new AccountIds().addresses(addresses.stream().map(Address::plain).collect(Collectors.toList()));
        return this.getAccountsNames(accountIds);
    }

    private Observable<List<AccountNames>> getAccountsNames(AccountIds accountIds) {
        Consumer callback = handler -> this.getClient().getAccountsNames(accountIds, handler);
        return this.exceptionHandling(this.call(callback).map(AccountsNamesDTO::getAccountNames).flatMapIterable(item -> item).map(this::toAccountNames).toList().toObservable());
    }

    private AccountNames toAccountNames(AccountNamesDTO dto) {
        return new AccountNames(MapperUtils.toAddressFromEncoded((String)dto.getAddress()), dto.getNames().stream().map(NamespaceName::new).collect(Collectors.toList()));
    }

    public Observable<List<AccountInfo>> getAccountsInfo(List<Address> addresses) {
        AccountIds accountIds = new AccountIds().addresses(addresses.stream().map(Address::plain).collect(Collectors.toList()));
        Consumer callback = handler -> this.getClient().getAccountsInfo(accountIds, handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(AccountInfoDTO::getAccount).map(this::toAccountInfo).toList().toObservable());
    }

    public Observable<MultisigAccountInfo> getMultisigAccountInfo(Address address) {
        return this.exceptionHandling(this.call(handler -> this.getClient().getAccountMultisig(address.plain(), handler)).map(MultisigAccountInfoDTO::getMultisig).map(this::toMultisigAccountInfo));
    }

    public Observable<MultisigAccountGraphInfo> getMultisigAccountGraphInfo(Address address) {
        return this.exceptionHandling(this.call(handler -> this.getClient().getAccountMultisigGraph(address.plain(), handler)).map(multisigAccountGraphInfoDTOList -> {
            HashMap multisigAccountInfoMap = new HashMap();
            multisigAccountGraphInfoDTOList.forEach(item -> multisigAccountInfoMap.put(item.getLevel(), this.toMultisigAccountInfo((MultisigAccountGraphInfoDTO)item)));
            return new MultisigAccountGraphInfo(multisigAccountInfoMap);
        }));
    }

    private List<MultisigAccountInfo> toMultisigAccountInfo(MultisigAccountGraphInfoDTO item) {
        return item.getMultisigEntries().stream().map(MultisigAccountInfoDTO::getMultisig).map(this::toMultisigAccountInfo).collect(Collectors.toList());
    }

    public Observable<List<Transaction>> transactions(PublicAccount publicAccount) {
        return this.transactions(publicAccount, Optional.empty());
    }

    public Observable<List<Transaction>> transactions(PublicAccount publicAccount, QueryParams queryParams) {
        return this.transactions(publicAccount, Optional.of(queryParams));
    }

    private Observable<List<Transaction>> transactions(PublicAccount publicAccount, Optional<QueryParams> queryParams) {
        Consumer callback = handler -> this.client.transactions(publicAccount.getPublicKey().toHex(), this.getPageSize(queryParams), this.getId(queryParams), null, handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransaction).toList().toObservable());
    }

    public Observable<List<Transaction>> incomingTransactions(PublicAccount publicAccount) {
        return this.incomingTransactions(publicAccount, Optional.empty());
    }

    public Observable<List<Transaction>> incomingTransactions(PublicAccount publicAccount, QueryParams queryParams) {
        return this.incomingTransactions(publicAccount, Optional.of(queryParams));
    }

    private Observable<List<Transaction>> incomingTransactions(PublicAccount publicAccount, Optional<QueryParams> queryParams) {
        Consumer callback = handler -> this.client.incomingTransactions(publicAccount.getPublicKey().toHex(), this.getPageSize(queryParams), this.getId(queryParams), null, handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransaction).toList().toObservable());
    }

    public Observable<List<Transaction>> outgoingTransactions(PublicAccount publicAccount) {
        return this.outgoingTransactions(publicAccount, Optional.empty());
    }

    public Observable<List<Transaction>> outgoingTransactions(PublicAccount publicAccount, QueryParams queryParams) {
        return this.outgoingTransactions(publicAccount, Optional.of(queryParams));
    }

    private Observable<List<Transaction>> outgoingTransactions(PublicAccount publicAccount, Optional<QueryParams> queryParams) {
        Consumer callback = handler -> this.client.outgoingTransactions(publicAccount.getPublicKey().toHex(), this.getPageSize(queryParams), this.getId(queryParams), null, handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransaction).toList().toObservable());
    }

    private Transaction toTransaction(TransactionInfoDTO input) {
        return this.transactionMapper.map(input);
    }

    public Observable<List<AggregateTransaction>> aggregateBondedTransactions(PublicAccount publicAccount) {
        return this.aggregateBondedTransactions(publicAccount, Optional.empty());
    }

    public Observable<List<AggregateTransaction>> aggregateBondedTransactions(PublicAccount publicAccount, QueryParams queryParams) {
        return this.aggregateBondedTransactions(publicAccount, Optional.of(queryParams));
    }

    private Observable<List<AggregateTransaction>> aggregateBondedTransactions(PublicAccount publicAccount, Optional<QueryParams> queryParams) {
        Consumer callback = handler -> this.client.partialTransactions(publicAccount.getPublicKey().toHex(), this.getPageSize(queryParams), this.getId(queryParams), null, handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransaction).map(o -> (AggregateTransaction)o).toList().toObservable());
    }

    public Observable<List<Transaction>> unconfirmedTransactions(PublicAccount publicAccount) {
        return this.unconfirmedTransactions(publicAccount, Optional.empty());
    }

    public Observable<List<Transaction>> unconfirmedTransactions(PublicAccount publicAccount, QueryParams queryParams) {
        return this.unconfirmedTransactions(publicAccount, Optional.of(queryParams));
    }

    private Observable<List<Transaction>> unconfirmedTransactions(PublicAccount publicAccount, Optional<QueryParams> queryParams) {
        Consumer callback = handler -> this.client.unconfirmedTransactions(publicAccount.getPublicKey().toHex(), this.getPageSize(queryParams), this.getId(queryParams), null, handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransaction).toList().toObservable());
    }

    private AccountInfo toAccountInfo(AccountDTO accountDTO) {
        return new AccountInfo(MapperUtils.toAddressFromEncoded((String)accountDTO.getAddress()), accountDTO.getAddressHeight(), accountDTO.getPublicKey(), accountDTO.getPublicKeyHeight(), accountDTO.getImportance(), accountDTO.getImportanceHeight(), accountDTO.getMosaics().stream().map(mosaicDTO -> new Mosaic((UnresolvedMosaicId)MapperUtils.toMosaicId((String)mosaicDTO.getId()), mosaicDTO.getAmount())).collect(Collectors.toList()), AccountType.rawValueOf((int)accountDTO.getAccountType().getValue()));
    }

    private MultisigAccountInfo toMultisigAccountInfo(MultisigDTO dto) {
        NetworkType networkType = this.getNetworkTypeBlocking();
        return new MultisigAccountInfo(new PublicAccount(dto.getAccountPublicKey(), networkType), dto.getMinApproval().intValue(), dto.getMinRemoval().intValue(), dto.getCosignatoryPublicKeys().stream().map(cosigner -> new PublicAccount(cosigner, networkType)).collect(Collectors.toList()), dto.getMultisigPublicKeys().stream().map(multisigAccount -> new PublicAccount(multisigAccount, networkType)).collect(Collectors.toList()));
    }

    private AccountRoutesApi getClient() {
        return this.client;
    }
}

