/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp.mappers;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.infrastructure.okhttp.mappers.AbstractTransactionMapper;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.MosaicId;
import io.nem.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.sdk.model.namespace.AliasAction;
import io.nem.sdk.model.namespace.NamespaceId;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.MosaicAliasTransaction;
import io.nem.sdk.model.transaction.MosaicAliasTransactionFactory;
import io.nem.sdk.model.transaction.TransactionFactory;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.okhttp_gson.model.AliasActionEnum;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicAliasTransactionDTO;

class MosaicAliasTransactionMapper
extends AbstractTransactionMapper<MosaicAliasTransactionDTO, MosaicAliasTransaction> {
    public MosaicAliasTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.MOSAIC_ALIAS, MosaicAliasTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<MosaicAliasTransaction> createFactory(NetworkType networkType, MosaicAliasTransactionDTO transaction) {
        NamespaceId namespaceId = MapperUtils.toNamespaceId((String)transaction.getNamespaceId());
        AliasAction aliasAction = AliasAction.rawValueOf((byte)transaction.getAliasAction().getValue().byteValue());
        return MosaicAliasTransactionFactory.create((NetworkType)networkType, (AliasAction)aliasAction, (NamespaceId)namespaceId, (MosaicId)MapperUtils.toMosaicId((String)transaction.getMosaicId()));
    }

    @Override
    protected void copyToDto(MosaicAliasTransaction transaction, MosaicAliasTransactionDTO dto) {
        dto.setAliasAction(AliasActionEnum.fromValue((Integer)Integer.valueOf(transaction.getAliasAction().getValue())));
        dto.setNamespaceId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getNamespaceId()));
        dto.setMosaicId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getMosaicId()));
    }
}

