/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp.mappers;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.infrastructure.okhttp.mappers.AbstractTransactionMapper;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.AccountMosaicRestrictionTransaction;
import io.nem.sdk.model.transaction.AccountMosaicRestrictionTransactionFactory;
import io.nem.sdk.model.transaction.AccountRestrictionFlags;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.okhttp_gson.model.AccountMosaicRestrictionTransactionDTO;
import io.nem.sdk.openapi.okhttp_gson.model.AccountRestrictionFlagsEnum;
import java.util.List;
import java.util.stream.Collectors;

public class AccountMosaicRestrictionTransactionMapper
extends AbstractTransactionMapper<AccountMosaicRestrictionTransactionDTO, AccountMosaicRestrictionTransaction> {
    public AccountMosaicRestrictionTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.ACCOUNT_MOSAIC_RESTRICTION, AccountMosaicRestrictionTransactionDTO.class);
    }

    protected AccountMosaicRestrictionTransactionFactory createFactory(NetworkType networkType, AccountMosaicRestrictionTransactionDTO transaction) {
        AccountRestrictionFlags restrictionFlags = AccountRestrictionFlags.rawValueOf((int)transaction.getRestrictionFlags().getValue());
        List additions = transaction.getRestrictionAdditions().stream().map(MapperUtils::toUnresolvedMosaicId).collect(Collectors.toList());
        List deletions = transaction.getRestrictionDeletions().stream().map(MapperUtils::toUnresolvedMosaicId).collect(Collectors.toList());
        return AccountMosaicRestrictionTransactionFactory.create((NetworkType)networkType, (AccountRestrictionFlags)restrictionFlags, additions, deletions);
    }

    @Override
    protected void copyToDto(AccountMosaicRestrictionTransaction transaction, AccountMosaicRestrictionTransactionDTO dto) {
        dto.setRestrictionFlags(AccountRestrictionFlagsEnum.fromValue((Integer)transaction.getRestrictionFlags().getValue()));
        List additions = transaction.getRestrictionAdditions().stream().map(MapperUtils::getIdAsHex).collect(Collectors.toList());
        List deletions = transaction.getRestrictionDeletions().stream().map(MapperUtils::getIdAsHex).collect(Collectors.toList());
        dto.setRestrictionAdditions(additions);
        dto.setRestrictionDeletions(deletions);
    }
}

