/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp;

import io.nem.sdk.api.TransactionRepository;
import io.nem.sdk.infrastructure.okhttp.AbstractRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.mappers.GeneralTransactionMapper;
import io.nem.sdk.model.transaction.CosignatureSignedTransaction;
import io.nem.sdk.model.transaction.Deadline;
import io.nem.sdk.model.transaction.SignedTransaction;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.model.transaction.TransactionAnnounceResponse;
import io.nem.sdk.model.transaction.TransactionState;
import io.nem.sdk.model.transaction.TransactionStatus;
import io.nem.sdk.openapi.okhttp_gson.api.TransactionRoutesApi;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.model.AnnounceTransactionInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.Cosignature;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionHashes;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionIds;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionPayload;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionStatusDTO;
import io.reactivex.Observable;
import java.util.List;
import java.util.concurrent.Callable;

public class TransactionRepositoryOkHttpImpl
extends AbstractRepositoryOkHttpImpl
implements TransactionRepository {
    private final TransactionRoutesApi client;
    private final GeneralTransactionMapper transactionMapper;

    public TransactionRepositoryOkHttpImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new TransactionRoutesApi(apiClient);
        this.transactionMapper = new GeneralTransactionMapper(this.getJsonHelper());
    }

    public TransactionRoutesApi getClient() {
        return this.client;
    }

    public Observable<Transaction> getTransaction(String transactionHash) {
        Callable<TransactionInfoDTO> callback = () -> this.getClient().getTransaction(transactionHash);
        return this.exceptionHandling(this.call(callback).map(this::toTransaction));
    }

    private Transaction toTransaction(TransactionInfoDTO input) {
        return this.transactionMapper.map(input);
    }

    public Observable<List<Transaction>> getTransactions(List<String> transactionHashes) {
        Callable<List> callback = () -> this.getClient().getTransactions(new TransactionIds().transactionIds(transactionHashes));
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransaction).toList().toObservable());
    }

    public Observable<TransactionStatus> getTransactionStatus(String transactionHash) {
        Callable<TransactionStatusDTO> callback = () -> this.getClient().getTransactionStatus(transactionHash);
        return this.exceptionHandling(this.call(callback).map(this::toTransactionStatus));
    }

    private TransactionStatus toTransactionStatus(TransactionStatusDTO transactionStatusDTO) {
        return new TransactionStatus(TransactionState.valueOf((String)transactionStatusDTO.getGroup().name()), transactionStatusDTO.getCode() == null ? null : transactionStatusDTO.getCode().getValue(), transactionStatusDTO.getHash(), new Deadline(transactionStatusDTO.getDeadline()), transactionStatusDTO.getHeight());
    }

    public Observable<List<TransactionStatus>> getTransactionStatuses(List<String> transactionHashes) {
        Callable<List> callback = () -> this.getClient().getTransactionsStatuses(new TransactionHashes().hashes(transactionHashes));
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransactionStatus).toList().toObservable());
    }

    public Observable<TransactionAnnounceResponse> announce(SignedTransaction signedTransaction) {
        Callable<AnnounceTransactionInfoDTO> callback = () -> this.getClient().announceTransaction(new TransactionPayload().payload(signedTransaction.getPayload()));
        return this.exceptionHandling(this.call(callback).map(dto -> new TransactionAnnounceResponse(dto.getMessage())));
    }

    public Observable<TransactionAnnounceResponse> announceAggregateBonded(SignedTransaction signedTransaction) {
        Callable<AnnounceTransactionInfoDTO> callback = () -> this.getClient().announcePartialTransaction(new TransactionPayload().payload(signedTransaction.getPayload()));
        return this.exceptionHandling(this.call(callback).map(dto -> new TransactionAnnounceResponse(dto.getMessage())));
    }

    public Observable<TransactionAnnounceResponse> announceAggregateBondedCosignature(CosignatureSignedTransaction cosignatureSignedTransaction) {
        Callable<AnnounceTransactionInfoDTO> callback = () -> this.getClient().announceCosignatureTransaction(new Cosignature().parentHash(cosignatureSignedTransaction.getParentHash()).signature(cosignatureSignedTransaction.getSignature()).signerPublicKey(cosignatureSignedTransaction.getSigner()));
        return this.exceptionHandling(this.call(callback).map(dto -> new TransactionAnnounceResponse(dto.getMessage())));
    }
}

