/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.api.NamespaceRepository;
import io.nem.sdk.api.QueryParams;
import io.nem.sdk.infrastructure.okhttp.AbstractRepositoryOkHttpImpl;
import io.nem.sdk.model.account.AccountNames;
import io.nem.sdk.model.account.Address;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.MosaicId;
import io.nem.sdk.model.mosaic.MosaicNames;
import io.nem.sdk.model.namespace.AddressAlias;
import io.nem.sdk.model.namespace.Alias;
import io.nem.sdk.model.namespace.AliasType;
import io.nem.sdk.model.namespace.EmptyAlias;
import io.nem.sdk.model.namespace.MosaicAlias;
import io.nem.sdk.model.namespace.NamespaceId;
import io.nem.sdk.model.namespace.NamespaceInfo;
import io.nem.sdk.model.namespace.NamespaceName;
import io.nem.sdk.model.namespace.NamespaceRegistrationType;
import io.nem.sdk.openapi.okhttp_gson.api.NamespaceRoutesApi;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.model.AccountIds;
import io.nem.sdk.openapi.okhttp_gson.model.AccountNamesDTO;
import io.nem.sdk.openapi.okhttp_gson.model.AccountsNamesDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicIds;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicNamesDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicsNamesDTO;
import io.nem.sdk.openapi.okhttp_gson.model.NamespaceDTO;
import io.nem.sdk.openapi.okhttp_gson.model.NamespaceIds;
import io.nem.sdk.openapi.okhttp_gson.model.NamespaceInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.NamespaceNameDTO;
import io.nem.sdk.openapi.okhttp_gson.model.NamespacesInfoDTO;
import io.reactivex.Observable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class NamespaceRepositoryOkHttpImpl
extends AbstractRepositoryOkHttpImpl
implements NamespaceRepository {
    private final NamespaceRoutesApi client;
    private final Observable<NetworkType> networkTypeObservable;

    public NamespaceRepositoryOkHttpImpl(ApiClient apiClient, Observable<NetworkType> networkTypeObservable) {
        super(apiClient);
        this.client = new NamespaceRoutesApi(apiClient);
        this.networkTypeObservable = networkTypeObservable;
    }

    public NamespaceRoutesApi getClient() {
        return this.client;
    }

    public Observable<NamespaceInfo> getNamespace(NamespaceId namespaceId) {
        Callable<NamespaceInfoDTO> callback = () -> this.getClient().getNamespace(namespaceId.getIdAsHex());
        return this.exceptionHandling(this.networkTypeObservable.flatMap(networkType -> this.call(callback).map(namespaceInfoDTO -> this.toNamespaceInfo((NamespaceInfoDTO)namespaceInfoDTO, (NetworkType)networkType))));
    }

    public Observable<List<NamespaceInfo>> getNamespacesFromAccount(Address address, QueryParams queryParams) {
        return this.getNamespacesFromAccount(address, Optional.of(queryParams));
    }

    public Observable<List<NamespaceInfo>> getNamespacesFromAccount(Address address) {
        return this.getNamespacesFromAccount(address, Optional.empty());
    }

    private Observable<List<NamespaceInfo>> getNamespacesFromAccount(Address address, Optional<QueryParams> queryParams) {
        Callable<NamespacesInfoDTO> callback = () -> this.getClient().getNamespacesFromAccount(address.plain(), this.getPageSize(queryParams), this.getId(queryParams));
        return this.exceptionHandling(this.networkTypeObservable.flatMap(networkType -> this.call(callback).flatMapIterable(NamespacesInfoDTO::getNamespaces).map(namespaceInfoDTO -> this.toNamespaceInfo((NamespaceInfoDTO)namespaceInfoDTO, (NetworkType)networkType)).toList().toObservable()));
    }

    public Observable<List<NamespaceInfo>> getNamespacesFromAccounts(List<Address> addresses) {
        AccountIds accounts = new AccountIds().addresses(addresses.stream().map(Address::plain).collect(Collectors.toList()));
        Callable<NamespacesInfoDTO> callback = () -> this.getClient().getNamespacesFromAccounts(accounts);
        return this.exceptionHandling(this.networkTypeObservable.flatMap(networkType -> this.call(callback).flatMapIterable(NamespacesInfoDTO::getNamespaces).map(namespaceInfoDTO -> this.toNamespaceInfo((NamespaceInfoDTO)namespaceInfoDTO, (NetworkType)networkType)).toList().toObservable()));
    }

    public Observable<List<NamespaceName>> getNamespaceNames(List<NamespaceId> namespaceIds) {
        NamespaceIds ids = new NamespaceIds().namespaceIds(namespaceIds.stream().map(NamespaceId::getIdAsHex).collect(Collectors.toList()));
        Callable<List> callback = () -> this.getClient().getNamespacesNames(ids);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toNamespaceName).toList().toObservable());
    }

    private NamespaceName toNamespaceName(NamespaceNameDTO dto) {
        return new NamespaceName(MapperUtils.toNamespaceId((String)dto.getId()), dto.getName(), Optional.ofNullable(MapperUtils.toNamespaceId((String)dto.getParentId())));
    }

    public Observable<MosaicId> getLinkedMosaicId(NamespaceId namespaceId) {
        Callable<NamespaceInfoDTO> callback = () -> this.getClient().getNamespace(namespaceId.getIdAsHex());
        return this.exceptionHandling(this.call(callback).map(namespaceInfoDTO -> this.toMosaicId(namespaceInfoDTO.getNamespace())));
    }

    public Observable<Address> getLinkedAddress(NamespaceId namespaceId) {
        Callable<NamespaceInfoDTO> callback = () -> this.getClient().getNamespace(namespaceId.getIdAsHex());
        return this.exceptionHandling(this.call(callback).map(namespaceInfoDTO -> this.toAddress(namespaceInfoDTO.getNamespace())));
    }

    public Observable<List<AccountNames>> getAccountsNames(List<Address> addresses) {
        AccountIds accountIds = new AccountIds().addresses(addresses.stream().map(Address::plain).collect(Collectors.toList()));
        return this.getAccountNames(accountIds);
    }

    private Observable<List<AccountNames>> getAccountNames(AccountIds accountIds) {
        Callable<AccountsNamesDTO> callback = () -> this.getClient().getAccountsNames(accountIds);
        return this.exceptionHandling(this.call(callback).map(AccountsNamesDTO::getAccountNames).flatMapIterable(item -> item).map(this::toAccountNames).toList().toObservable());
    }

    private AccountNames toAccountNames(AccountNamesDTO dto) {
        return new AccountNames(MapperUtils.toAddressFromEncoded((String)dto.getAddress()), dto.getNames().stream().map(NamespaceName::new).collect(Collectors.toList()));
    }

    public Observable<List<MosaicNames>> getMosaicsNames(List<MosaicId> ids) {
        MosaicIds mosaicIds = new MosaicIds();
        mosaicIds.mosaicIds(ids.stream().map(MosaicId::getIdAsHex).collect(Collectors.toList()));
        Callable<MosaicsNamesDTO> callback = () -> this.getClient().getMosaicsNames(mosaicIds);
        return this.exceptionHandling(this.call(callback).map(MosaicsNamesDTO::getMosaicNames).flatMapIterable(item -> item).map(this::toMosaicNames).toList().toObservable());
    }

    private MosaicNames toMosaicNames(MosaicNamesDTO dto) {
        return new MosaicNames(MapperUtils.toMosaicId((String)dto.getMosaicId()), dto.getNames().stream().map(NamespaceName::new).collect(Collectors.toList()));
    }

    private NamespaceInfo toNamespaceInfo(NamespaceInfoDTO namespaceInfoDTO, NetworkType networkType) {
        return new NamespaceInfo(namespaceInfoDTO.getMeta().getActive().booleanValue(), namespaceInfoDTO.getMeta().getIndex(), namespaceInfoDTO.getMeta().getId(), NamespaceRegistrationType.rawValueOf((int)namespaceInfoDTO.getNamespace().getRegistrationType().getValue()), namespaceInfoDTO.getNamespace().getDepth(), this.extractLevels(namespaceInfoDTO), MapperUtils.toNamespaceId((String)namespaceInfoDTO.getNamespace().getParentId()), new PublicAccount(namespaceInfoDTO.getNamespace().getOwnerPublicKey(), networkType), namespaceInfoDTO.getNamespace().getStartHeight(), namespaceInfoDTO.getNamespace().getEndHeight(), this.extractAlias(namespaceInfoDTO.getNamespace()));
    }

    private List<NamespaceId> extractLevels(NamespaceInfoDTO namespaceInfoDTO) {
        ArrayList<NamespaceId> levels = new ArrayList<NamespaceId>();
        if (namespaceInfoDTO.getNamespace().getLevel0() != null) {
            levels.add(MapperUtils.toNamespaceId((String)namespaceInfoDTO.getNamespace().getLevel0()));
        }
        if (namespaceInfoDTO.getNamespace().getLevel1() != null) {
            levels.add(MapperUtils.toNamespaceId((String)namespaceInfoDTO.getNamespace().getLevel1()));
        }
        if (namespaceInfoDTO.getNamespace().getLevel2() != null) {
            levels.add(MapperUtils.toNamespaceId((String)namespaceInfoDTO.getNamespace().getLevel2()));
        }
        return levels;
    }

    private Alias extractAlias(NamespaceDTO namespaceDTO) {
        EmptyAlias alias = new EmptyAlias();
        if (namespaceDTO.getAlias() != null) {
            if (namespaceDTO.getAlias().getType().getValue().equals(AliasType.MOSAIC.getValue())) {
                return new MosaicAlias(this.toMosaicId(namespaceDTO));
            }
            if (namespaceDTO.getAlias().getType().getValue().equals(AliasType.ADDRESS.getValue())) {
                return new AddressAlias(this.toAddress(namespaceDTO));
            }
        }
        return alias;
    }

    private MosaicId toMosaicId(NamespaceDTO namespaceDTO) {
        if (namespaceDTO.getAlias() != null && AliasType.MOSAIC.getValue().equals(namespaceDTO.getAlias().getType().getValue())) {
            return MapperUtils.toMosaicId((String)namespaceDTO.getAlias().getMosaicId());
        }
        return null;
    }

    private Address toAddress(NamespaceDTO namespaceDTO) {
        if (namespaceDTO.getAlias() != null && AliasType.ADDRESS.getValue().equals(namespaceDTO.getAlias().getType().getValue())) {
            return MapperUtils.toAddressFromEncoded((String)namespaceDTO.getAlias().getAddress());
        }
        return null;
    }
}

