/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.api.RestrictionAccountRepository;
import io.nem.sdk.infrastructure.okhttp.AbstractRepositoryOkHttpImpl;
import io.nem.sdk.model.account.AccountRestriction;
import io.nem.sdk.model.account.AccountRestrictions;
import io.nem.sdk.model.account.Address;
import io.nem.sdk.model.transaction.AccountRestrictionFlags;
import io.nem.sdk.model.transaction.AccountRestrictionTargetType;
import io.nem.sdk.openapi.okhttp_gson.api.RestrictionAccountRoutesApi;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.model.AccountIds;
import io.nem.sdk.openapi.okhttp_gson.model.AccountRestrictionDTO;
import io.nem.sdk.openapi.okhttp_gson.model.AccountRestrictionsDTO;
import io.nem.sdk.openapi.okhttp_gson.model.AccountRestrictionsInfoDTO;
import io.reactivex.Observable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class RestrictionAccountRepositoryOkHttpImpl
extends AbstractRepositoryOkHttpImpl
implements RestrictionAccountRepository {
    private final RestrictionAccountRoutesApi client;

    public RestrictionAccountRepositoryOkHttpImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new RestrictionAccountRoutesApi(apiClient);
    }

    public Observable<AccountRestrictions> getAccountRestrictions(Address address) {
        Callable<AccountRestrictionsInfoDTO> callback = () -> this.getClient().getAccountRestrictions(address.plain());
        return this.exceptionHandling(this.call(callback).map(AccountRestrictionsInfoDTO::getAccountRestrictions).map(this::toAccountRestrictions));
    }

    public Observable<List<AccountRestrictions>> getAccountsRestrictions(List<Address> addresses) {
        AccountIds accountIds = new AccountIds().addresses(addresses.stream().map(Address::plain).collect(Collectors.toList()));
        return this.getAccountsRestrictions(accountIds);
    }

    private Observable<List<AccountRestrictions>> getAccountsRestrictions(AccountIds accountIds) {
        Callable<List> callback = () -> this.getClient().getAccountRestrictionsFromAccounts(accountIds);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(AccountRestrictionsInfoDTO::getAccountRestrictions).map(this::toAccountRestrictions)).toList().toObservable();
    }

    private AccountRestrictions toAccountRestrictions(AccountRestrictionsDTO dto) {
        return new AccountRestrictions(MapperUtils.toAddressFromEncoded((String)dto.getAddress()), dto.getRestrictions().stream().map(this::toAccountRestriction).collect(Collectors.toList()));
    }

    private AccountRestriction toAccountRestriction(AccountRestrictionDTO dto) {
        AccountRestrictionFlags restrictionFlags = AccountRestrictionFlags.rawValueOf((int)dto.getRestrictionFlags().getValue());
        return new AccountRestriction(restrictionFlags, dto.getValues().stream().filter(Objects::nonNull).map(Object::toString).map(arg_0 -> ((AccountRestrictionTargetType)restrictionFlags.getTargetType()).fromString(arg_0)).collect(Collectors.toList()));
    }

    public RestrictionAccountRoutesApi getClient() {
        return this.client;
    }
}

