/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp;

import io.nem.sdk.api.AccountRepository;
import io.nem.sdk.api.BlockRepository;
import io.nem.sdk.api.ChainRepository;
import io.nem.sdk.api.DiagnosticRepository;
import io.nem.sdk.api.JsonSerialization;
import io.nem.sdk.api.Listener;
import io.nem.sdk.api.MetadataRepository;
import io.nem.sdk.api.MosaicRepository;
import io.nem.sdk.api.MultisigRepository;
import io.nem.sdk.api.NamespaceRepository;
import io.nem.sdk.api.NetworkRepository;
import io.nem.sdk.api.NodeRepository;
import io.nem.sdk.api.ReceiptRepository;
import io.nem.sdk.api.RepositoryFactory;
import io.nem.sdk.api.RestrictionAccountRepository;
import io.nem.sdk.api.RestrictionMosaicRepository;
import io.nem.sdk.api.TransactionRepository;
import io.nem.sdk.infrastructure.okhttp.AccountRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.BlockRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.ChainRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.DiagnosticRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.JsonHelperGson;
import io.nem.sdk.infrastructure.okhttp.JsonSerializationOkHttp;
import io.nem.sdk.infrastructure.okhttp.ListenerOkHttp;
import io.nem.sdk.infrastructure.okhttp.MetadataRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.MosaicRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.MultisigRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.NamespaceRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.NetworkRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.NodeRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.ReceiptRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.RestrictionAccountRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.RestrictionMosaicRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.TransactionRepositoryOkHttpImpl;
import io.nem.sdk.model.blockchain.BlockInfo;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.reactivex.Observable;
import java.io.Closeable;
import java.math.BigInteger;
import okhttp3.OkHttpClient;
import org.apache.commons.io.IOUtils;

public class RepositoryFactoryOkHttpImpl
implements RepositoryFactory {
    private final ApiClient apiClient;
    private final String baseUrl;
    private final Observable<NetworkType> networkTypeObservable;
    private final Observable<String> generationHashObservable;

    public RepositoryFactoryOkHttpImpl(String baseUrl) {
        this.baseUrl = baseUrl;
        this.apiClient = new ApiClient();
        this.apiClient.setBasePath(baseUrl);
        this.apiClient.getJSON().setGson(JsonHelperGson.creatGson(false));
        this.networkTypeObservable = this.createNetworkRepository().getNetworkType().cache();
        this.generationHashObservable = this.createBlockRepository().getBlockByHeight(BigInteger.ONE).map(BlockInfo::getGenerationHash).cache();
    }

    public Observable<NetworkType> getNetworkType() {
        return this.networkTypeObservable;
    }

    public Observable<String> getGenerationHash() {
        return this.generationHashObservable;
    }

    public AccountRepository createAccountRepository() {
        return new AccountRepositoryOkHttpImpl(this.apiClient);
    }

    public MultisigRepository createMultisigRepository() {
        return new MultisigRepositoryOkHttpImpl(this.apiClient, this.getNetworkType());
    }

    public BlockRepository createBlockRepository() {
        return new BlockRepositoryOkHttpImpl(this.apiClient);
    }

    public ReceiptRepository createReceiptRepository() {
        return new ReceiptRepositoryOkHttpImpl(this.apiClient, this.getNetworkType());
    }

    public ChainRepository createChainRepository() {
        return new ChainRepositoryOkHttpImpl(this.apiClient);
    }

    public DiagnosticRepository createDiagnosticRepository() {
        return new DiagnosticRepositoryOkHttpImpl(this.apiClient);
    }

    public MosaicRepository createMosaicRepository() {
        return new MosaicRepositoryOkHttpImpl(this.apiClient, this.getNetworkType());
    }

    public NamespaceRepository createNamespaceRepository() {
        return new NamespaceRepositoryOkHttpImpl(this.apiClient, this.getNetworkType());
    }

    public NetworkRepository createNetworkRepository() {
        return new NetworkRepositoryOkHttpImpl(this.apiClient);
    }

    public NodeRepository createNodeRepository() {
        return new NodeRepositoryOkHttpImpl(this.apiClient);
    }

    public TransactionRepository createTransactionRepository() {
        return new TransactionRepositoryOkHttpImpl(this.apiClient);
    }

    public MetadataRepository createMetadataRepository() {
        return new MetadataRepositoryOkHttpImpl(this.apiClient);
    }

    public RestrictionAccountRepository createRestrictionAccountRepository() {
        return new RestrictionAccountRepositoryOkHttpImpl(this.apiClient);
    }

    public RestrictionMosaicRepository createRestrictionMosaicRepository() {
        return new RestrictionMosaicRepositoryOkHttpImpl(this.apiClient);
    }

    public Listener createListener() {
        return new ListenerOkHttp(this.apiClient.getHttpClient(), this.baseUrl, this.apiClient.getJSON());
    }

    public JsonSerialization createJsonSerialization() {
        return new JsonSerializationOkHttp(this.apiClient.getJSON().getGson());
    }

    public void close() {
        OkHttpClient client = this.apiClient.getHttpClient();
        client.dispatcher().executorService().shutdown();
        client.connectionPool().evictAll();
        IOUtils.closeQuietly((Closeable)client.cache());
    }
}

