/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp;

import io.nem.sdk.api.NetworkRepository;
import io.nem.sdk.infrastructure.okhttp.AbstractRepositoryOkHttpImpl;
import io.nem.sdk.model.blockchain.NetworkInfo;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.openapi.okhttp_gson.api.NetworkRoutesApi;
import io.nem.sdk.openapi.okhttp_gson.api.NodeRoutesApi;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.reactivex.Observable;

public class NetworkRepositoryOkHttpImpl
extends AbstractRepositoryOkHttpImpl
implements NetworkRepository {
    private final NetworkRoutesApi networkRoutesApi;
    private final NodeRoutesApi nodeRoutesApi;

    public NetworkRepositoryOkHttpImpl(ApiClient apiClient) {
        super(apiClient);
        this.networkRoutesApi = new NetworkRoutesApi(apiClient);
        this.nodeRoutesApi = new NodeRoutesApi(apiClient);
    }

    public Observable<NetworkType> getNetworkType() {
        return this.exceptionHandling(this.call(() -> ((NodeRoutesApi)this.getNodeRoutesApi()).getNodeInfo()).map(info -> NetworkType.rawValueOf((int)info.getNetworkIdentifier())));
    }

    public Observable<NetworkInfo> getNetworkInfo() {
        return this.exceptionHandling(this.call(() -> ((NetworkRoutesApi)this.getNetworkRoutesApi()).getNetworkType()).map(info -> new NetworkInfo(info.getName(), info.getDescription())));
    }

    public NetworkRoutesApi getNetworkRoutesApi() {
        return this.networkRoutesApi;
    }

    public NodeRoutesApi getNodeRoutesApi() {
        return this.nodeRoutesApi;
    }
}

